/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBaseColor
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        if (item instanceof dItem) {
            Material material = ((dItem)item).getItemStack().getType();
            return material == Material.BANNER || material == Material.WALL_BANNER || material == Material.STANDING_BANNER;
        }
        return false;
    }

    public static ItemBaseColor getFrom(dObject item) {
        if (!ItemBaseColor.describes(item)) {
            return null;
        }
        return new ItemBaseColor((dItem)item);
    }

    private ItemBaseColor(dItem item) {
        this.item = item;
    }

    private Element getBaseColor() {
        DyeColor baseColor = ((BannerMeta)this.item.getItemStack().getItemMeta()).getBaseColor();
        if (baseColor != null) {
            return new Element(baseColor.name());
        }
        return null;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("base_color")) {
            Element baseColor = this.getBaseColor();
            if (baseColor != null) {
                return this.getBaseColor().getAttribute(attribute.fulfill(1));
            }
            return new Element("BLACK").getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public String getPropertyString() {
        Element baseColor = this.getBaseColor();
        if (baseColor != null) {
            return this.getBaseColor().identify();
        }
        return null;
    }

    public String getPropertyId() {
        return "base_color";
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("base_color")) {
            BannerMeta bannerMeta = (BannerMeta)this.item.getItemStack().getItemMeta();
            bannerMeta.setBaseColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            this.item.getItemStack().setItemMeta((ItemMeta)bannerMeta);
        }
    }
}

