/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;

public class ListenCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<aH.Argument> arguments = new ArrayList<aH.Argument>();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
            } else if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id", "i")) {
                scriptEntry.addObject("id", arg.asElement());
            } else if (!scriptEntry.hasObject("finish_script") && arg.matchesPrefix("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("finish_script", arg.asType(dScript.class));
            } else if (!scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", arg.asElement());
            }
            arguments.add(arg);
        }
        scriptEntry.defaultObject("action", new Element("new"));
        scriptEntry.defaultObject("id", new Element(UUID.randomUUID().toString()));
        if (!scriptEntry.hasObject("type") && scriptEntry.getElement("action").asString().equalsIgnoreCase("new")) {
            throw new InvalidArgumentsException("Must specify a listener type!");
        }
        if (((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() == null) {
            throw new InvalidArgumentsException("Must specify a player!");
        }
        scriptEntry.addObject("args", arguments);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element action = scriptEntry.getElement("action");
        Element type = scriptEntry.getElement("type");
        Element id = scriptEntry.getElement("id");
        dScript finish_script = (dScript)scriptEntry.getObject("finish_script");
        dB.report(scriptEntry, this.getName(), action.debug() + (type != null ? type.debug() : "") + id.debug() + (finish_script != null ? finish_script.debug() : ""));
        dB.echoError(scriptEntry.getResidingQueue(), "Warning: Listen is outdated and may become unsupported in the future.");
        ArrayList arguments = (ArrayList)scriptEntry.getObject("args");
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case NEW: {
                if (DenizenAPI.getCurrentInstance().getListenerRegistry().getListenersFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()) != null && DenizenAPI.getCurrentInstance().getListenerRegistry().getListenersFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()).containsKey(id.asString().toLowerCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Cancelled creation of NEW listener! Listener ID '" + id.asString() + "' already exists!");
                    break;
                }
                if (finish_script == null) {
                    dB.echoError("Must specify a valid script!");
                    break;
                }
                try {
                    DenizenAPI.getCurrentInstance().getListenerRegistry().get(type.asString()).createInstance(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString()).build(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString(), type.asString(), arguments, finish_script, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC());
                }
                catch (Exception e) {
                    dB.echoDebug((Debuggable)scriptEntry, "Cancelled creation of NEW listener!");
                    if (DenizenAPI.getCurrentInstance().getListenerRegistry().get(type.asString()) == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Invalid listener type!");
                    } else {
                        dB.echoError(scriptEntry.getResidingQueue(), e);
                    }
                    try {
                        DenizenAPI.getCurrentInstance().getListenerRegistry().getListenerFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString()).cancel();
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case FINISH: {
                if (DenizenAPI.getCurrentInstance().getListenerRegistry().getListenerFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString()) == null) break;
                DenizenAPI.getCurrentInstance().getListenerRegistry().getListenerFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString()).finish();
                break;
            }
            case CANCEL: {
                if (((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() != null) {
                    if (id == null) break;
                    if (DenizenAPI.getCurrentInstance().getListenerRegistry().getListenerFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString()) != null) {
                        DenizenAPI.getCurrentInstance().getListenerRegistry().getListenerFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), id.asString()).cancel();
                        break;
                    }
                    for (AbstractListener listener : DenizenAPI.getCurrentInstance().getListenerRegistry().getListenersFor(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()).values()) {
                        listener.cancel();
                    }
                    break;
                }
                DenizenAPI.getCurrentInstance().getSaves().set("Listeners." + ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getName() + "." + id, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        NEW,
        CANCEL,
        FINISH;

    }
}

