/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class MidiCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("volume", "vol", "v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("tempo") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("tempo", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("file")) {
                String path = DenizenAPI.getCurrentInstance().getDataFolder() + File.separator + "midi" + File.separator + arg.getValue();
                if (!path.endsWith(".mid")) {
                    path = path + ".mid";
                }
                scriptEntry.addObject("file", new Element(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("file") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Missing file (Midi name) argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            scriptEntry.defaultObject("entities", ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity()) : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity()) : null);
        }
        scriptEntry.defaultObject("tempo", new Element(1)).defaultObject("volume", new Element(10));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        File file;
        boolean cancel = scriptEntry.hasObject("cancel");
        File file2 = file = !cancel ? new File(scriptEntry.getElement("file").asString()) : null;
        if (!cancel && !file.exists()) {
            dB.echoError(scriptEntry.getResidingQueue(), "Invalid file " + scriptEntry.getElement("file").asString());
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        float tempo = scriptEntry.getElement("tempo").asFloat();
        float volume = scriptEntry.getElement("volume").asFloat();
        dB.report(scriptEntry, this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + (file != null ? aH.debugObj("file", file.getPath()) : "") + (entities != null ? aH.debugObj("entities", entities.toString()) : "") + (location != null ? location.debug() : "") + aH.debugObj("tempo", Float.valueOf(tempo)) + aH.debugObj("volume", Float.valueOf(volume)));
        if (!cancel) {
            if (location != null) {
                MidiUtil.playMidi(file, tempo, volume, location);
            } else {
                MidiUtil.playMidi(file, tempo, volume, entities);
            }
        } else if (location != null) {
            MidiUtil.stopMidi(location.identify());
        } else {
            MidiUtil.stopMidi(entities);
        }
    }
}

