/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.nbt;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptHelper;
import net.minecraft.server.v1_8_R3.AttributeMapBase;
import net.minecraft.server.v1_8_R3.AttributeMapServer;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.IInventory;
import net.minecraft.server.v1_8_R3.InventoryEnderChest;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.NBTTagDouble;
import net.minecraft.server.v1_8_R3.NBTTagFloat;
import net.minecraft.server.v1_8_R3.NBTTagList;
import net.minecraft.server.v1_8_R3.PlayerAbilities;
import net.minecraft.server.v1_8_R3.PlayerInventory;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovedOfflinePlayer {
    private UUID player;
    private File file;
    private NBTTagCompound compound;
    private boolean exists = false;
    private boolean autosave = true;

    public ImprovedOfflinePlayer(UUID playeruuid) {
        this.exists = this.loadPlayerData(playeruuid);
    }

    public ImprovedOfflinePlayer(OfflinePlayer offlineplayer) {
        this.exists = this.loadPlayerData(offlineplayer.getUniqueId());
    }

    public org.bukkit.inventory.PlayerInventory getInventory() {
        if (InventoryScriptHelper.offlineInventories.containsKey(this.getUniqueId())) {
            return InventoryScriptHelper.offlineInventories.get(this.getUniqueId());
        }
        PlayerInventory inventory = new PlayerInventory(null);
        inventory.b(this.compound.getList("Inventory", 10));
        CraftInventoryPlayer inv = new CraftInventoryPlayer(inventory);
        InventoryScriptHelper.offlineInventories.put(this.getUniqueId(), (org.bukkit.inventory.PlayerInventory)inv);
        return inv;
    }

    public void setInventory(org.bukkit.inventory.PlayerInventory inventory) {
        CraftInventoryPlayer inv = (CraftInventoryPlayer)inventory;
        this.compound.set("Inventory", (NBTBase)inv.getInventory().a(new NBTTagList()));
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public Inventory getEnderChest() {
        if (InventoryScriptHelper.offlineEnderChests.containsKey(this.getUniqueId())) {
            return InventoryScriptHelper.offlineEnderChests.get(this.getUniqueId());
        }
        InventoryEnderChest endchest = new InventoryEnderChest();
        endchest.a(this.compound.getList("EnderItems", 10));
        CraftInventory inv = new CraftInventory((IInventory)endchest);
        InventoryScriptHelper.offlineEnderChests.put(this.getUniqueId(), (Inventory)inv);
        return inv;
    }

    public void setEnderChest(Inventory inventory) {
        this.compound.set("EnderItems", (NBTBase)((InventoryEnderChest)((CraftInventory)inventory).getInventory()).h());
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public Location getLocation() {
        NBTTagList position = this.compound.getList("Pos", 6);
        NBTTagList rotation = this.compound.getList("Rotation", 5);
        return new Location(Bukkit.getWorld((UUID)new UUID(this.compound.getLong("WorldUUIDMost"), this.compound.getLong("WorldUUIDLeast"))), position.d(0), position.d(1), position.d(2), rotation.e(0), rotation.e(1));
    }

    public void setLocation(Location location) {
        World w = location.getWorld();
        UUID uuid = w.getUID();
        this.compound.setLong("WorldUUIDMost", uuid.getMostSignificantBits());
        this.compound.setLong("WorldUUIDLeast", uuid.getLeastSignificantBits());
        this.compound.setInt("Dimension", w.getEnvironment().ordinal());
        NBTTagList position = new NBTTagList();
        position.add((NBTBase)new NBTTagDouble(location.getX()));
        position.add((NBTBase)new NBTTagDouble(location.getY()));
        position.add((NBTBase)new NBTTagDouble(location.getZ()));
        this.compound.set("Pos", (NBTBase)position);
        NBTTagList rotation = new NBTTagList();
        rotation.add((NBTBase)new NBTTagFloat(location.getYaw()));
        rotation.add((NBTBase)new NBTTagFloat(location.getPitch()));
        this.compound.set("Rotation", (NBTBase)rotation);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getHealthFloat() {
        return this.compound.getFloat("HealF");
    }

    public void setHealthFloat(float input) {
        this.compound.setFloat("HealF", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public double getMaxHealth() {
        return this.getAttributes().a("generic.maxHealth").getValue();
    }

    public void setMaxHealth(double input) {
        AttributeMapBase attributes = this.getAttributes();
        attributes.a("generic.maxHealth").setValue(input);
        this.setAttributes(attributes);
    }

    private boolean loadPlayerData(UUID uuid) {
        try {
            this.player = uuid;
            for (World w : Bukkit.getWorlds()) {
                this.file = new File(w.getWorldFolder(), "playerdata" + File.separator + this.player + ".dat");
                if (!this.file.exists()) continue;
                this.compound = NBTCompressedStreamTools.a((InputStream)new FileInputStream(this.file));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void savePlayerData() {
        if (this.exists) {
            try {
                NBTCompressedStreamTools.a((NBTTagCompound)this.compound, (OutputStream)new FileOutputStream(this.file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean getAutoSave() {
        return this.autosave;
    }

    public void setAutoSave(boolean autosave) {
        this.autosave = autosave;
    }

    public void copyDataTo(UUID playeruuid) {
        try {
            if (!playeruuid.equals(this.player)) {
                Player to = Bukkit.getPlayer((UUID)playeruuid);
                Player from = Bukkit.getPlayer((UUID)playeruuid);
                if (from != null) {
                    from.saveData();
                }
                Files.copy(this.file, new File(this.file.getParentFile(), playeruuid + ".dat"));
                if (to != null) {
                    to.teleport(from == null ? this.getLocation() : from.getLocation());
                    to.loadData();
                }
            } else {
                Player player = Bukkit.getPlayer((UUID)playeruuid);
                if (player != null) {
                    player.saveData();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PlayerAbilities getAbilities() {
        PlayerAbilities pa = new PlayerAbilities();
        pa.a(this.compound);
        return pa;
    }

    public void setAbilities(PlayerAbilities abilities) {
        abilities.a(this.compound);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getAbsorptionAmount() {
        return this.compound.getFloat("AbsorptionAmount");
    }

    public void setAbsorptionAmount(float input) {
        this.compound.setFloat("AbsorptionAmount", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public AttributeMapBase getAttributes() {
        AttributeMapServer amb = new AttributeMapServer();
        GenericAttributes.a((AttributeMapBase)amb, (NBTTagList)this.compound.getList("Attributes", 0));
        return amb;
    }

    public void setAttributes(AttributeMapBase attributes) {
        this.compound.set("Attributes", (NBTBase)GenericAttributes.a((AttributeMapBase)attributes));
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public Location getBedSpawnLocation() {
        return new Location(Bukkit.getWorld((String)this.compound.getString("SpawnWorld")), (double)this.compound.getInt("SpawnX"), (double)this.compound.getInt("SpawnY"), (double)this.compound.getInt("SpawnZ"));
    }

    public boolean isSpawnForced() {
        return this.compound.getBoolean("SpawnForced");
    }

    public void setBedSpawnLocation(Location location, Boolean override) {
        this.compound.setInt("SpawnX", (int)location.getX());
        this.compound.setInt("SpawnY", (int)location.getY());
        this.compound.setInt("SpawnZ", (int)location.getZ());
        this.compound.setString("SpawnWorld", location.getWorld().getName());
        this.compound.setBoolean("SpawnForced", override == null ? false : override);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getExhaustion() {
        return this.compound.getFloat("foodExhaustionLevel");
    }

    public void setExhaustion(float input) {
        this.compound.setFloat("foodExhaustionLevel", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getExp() {
        return this.compound.getFloat("XpP");
    }

    public void setExp(float input) {
        this.compound.setFloat("XpP", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getFallDistance() {
        return this.compound.getFloat("FallDistance");
    }

    public void setFallDistance(float input) {
        this.compound.setFloat("FallDistance", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getFireTicks() {
        return this.compound.getShort("Fire");
    }

    public void setFireTicks(int input) {
        this.compound.setShort("Fire", (short)input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getFlySpeed() {
        return this.compound.getCompound("abilities").getFloat("flySpeed");
    }

    public void setFlySpeed(float speed) {
        this.compound.getCompound("abilities").setFloat("flySpeed", speed);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getFoodLevel() {
        return this.compound.getInt("foodLevel");
    }

    public void setFoodLevel(int input) {
        this.compound.setInt("foodLevel", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getFoodTickTimer() {
        return this.compound.getInt("foodTickTimer");
    }

    public void setFoodTickTimer(int input) {
        this.compound.setInt("foodTickTimer", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public GameMode getGameMode() {
        return GameMode.values()[this.compound.getInt("playerGameType")];
    }

    public void setGameMode(GameMode input) {
        this.compound.setInt("playerGameType", input.getValue());
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getHealthInt() {
        return this.compound.getShort("Health");
    }

    public void setHealthInt(int input) {
        this.compound.setShort("Health", (short)input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public boolean getIsInvulnerable() {
        return this.compound.getBoolean("Invulnerable");
    }

    public void setIsInvulnerable(boolean input) {
        this.compound.setBoolean("Invulnerable", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public boolean getIsOnGround() {
        return this.compound.getBoolean("OnGround");
    }

    public void setIsOnGround(boolean input) {
        this.compound.setBoolean("OnGround", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public boolean getIsSleeping() {
        return this.compound.getBoolean("Sleeping");
    }

    public void setIsSleeping(boolean input) {
        this.compound.setBoolean("Sleeping", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getItemInHand() {
        return this.compound.getInt("SelectedItemSlot");
    }

    public void setItemInHand(int input) {
        this.compound.setInt("SelectedItemSlot", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getLevel() {
        return this.compound.getInt("XpLevel");
    }

    public void setLevel(int input) {
        this.compound.setInt("XpLevel", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public UUID getUniqueId() {
        return this.player;
    }

    public int getPortalCooldown() {
        return this.compound.getInt("PortalCooldown");
    }

    public void setPortalCooldown(int input) {
        this.compound.setInt("PortalCooldown", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public ArrayList<PotionEffect> getPotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        if (this.compound.hasKey("ActiveEffects")) {
            NBTTagList list = this.compound.getList("ActiveEffects", 0);
            for (int i = 0; i < list.size(); ++i) {
                NBTTagCompound effect = list.get(i);
                byte amp = effect.getByte("Amplifier");
                byte id = effect.getByte("Id");
                int time = effect.getInt("Duration");
                effects.add(new PotionEffect(PotionEffectType.getById((int)id), time, (int)amp));
            }
        }
        return effects;
    }

    public void setPotionEffects(ArrayList<PotionEffect> effects) {
        if (effects.isEmpty()) {
            this.compound.remove("ActiveEffects");
            if (this.autosave) {
                this.savePlayerData();
            }
            return;
        }
        NBTTagList activeEffects = new NBTTagList();
        for (PotionEffect pe : effects) {
            NBTTagCompound eCompound = new NBTTagCompound();
            eCompound.setByte("Amplifier", (byte)pe.getAmplifier());
            eCompound.setByte("Id", (byte)pe.getType().getId());
            eCompound.setInt("Duration", pe.getDuration());
            activeEffects.add((NBTBase)eCompound);
        }
        this.compound.set("ActiveEffects", (NBTBase)activeEffects);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getRemainingAir() {
        return this.compound.getShort("Air");
    }

    public void setRemainingAir(int input) {
        this.compound.setShort("Air", (short)input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getSaturation() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setSaturation(float input) {
        this.compound.setFloat("foodSaturationLevel", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getScore() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setScore(int input) {
        this.compound.setInt("Score", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeAttack() {
        return this.compound.getShort("AttackTime");
    }

    public void setTimeAttack(short input) {
        this.compound.setShort("AttackTime", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeDeath() {
        return this.compound.getShort("DeathTime");
    }

    public void setTimeDeath(short input) {
        this.compound.setShort("DeathTime", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeHurt() {
        return this.compound.getShort("HurtTime");
    }

    public void setTimeHurt(short input) {
        this.compound.setShort("HurtTime", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeSleep() {
        return this.compound.getShort("SleepTimer");
    }

    public void setTimeSleep(short input) {
        this.compound.setShort("SleepTimer", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getTotalExperience() {
        return this.compound.getInt("XpTotal");
    }

    public void setTotalExperience(int input) {
        this.compound.setInt("XpTotal", input);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public Vector getVelocity() {
        NBTTagList list = this.compound.getList("Motion", 6);
        return new Vector(list.d(0), list.d(1), list.d(2));
    }

    public void setVelocity(Vector vector) {
        NBTTagList motion = new NBTTagList();
        motion.add((NBTBase)new NBTTagDouble(vector.getX()));
        motion.add((NBTBase)new NBTTagDouble(vector.getY()));
        motion.add((NBTBase)new NBTTagDouble(vector.getZ()));
        this.compound.set("Motion", (NBTBase)motion);
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getWalkSpeed() {
        return this.compound.getCompound("abilities").getFloat("walkSpeed");
    }

    public void setWalkSpeed(float speed) {
        this.compound.getCompound("abilities").setFloat("walkSpeed", speed);
        if (this.autosave) {
            this.savePlayerData();
        }
    }
}

