/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.core.ReloadScriptsScriptEvent;
import net.aufdemrand.denizencore.events.core.SystemTimeScriptEvent;
import net.aufdemrand.denizencore.interfaces.ContextSource;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

public abstract class ScriptEvent
implements ContextSource,
Cloneable {
    public long fires = 0L;
    public long scriptFires = 0L;
    public long nanoTimes = 0L;
    public static ArrayList<ScriptContainer> worldContainers = new ArrayList();
    public static ArrayList<ScriptEvent> events = new ArrayList();
    public ArrayList<ScriptPath> eventPaths = new ArrayList();
    public boolean cancelled = false;

    public ScriptEvent clone() {
        try {
            return (ScriptEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            dB.echoError("Clone not supported for script events?!");
            return this;
        }
    }

    public static void registerCoreEvents() {
        ScriptEvent.registerScriptEvent(new ReloadScriptsScriptEvent());
        ScriptEvent.registerScriptEvent(new SystemTimeScriptEvent());
    }

    public static void registerScriptEvent(ScriptEvent event) {
        event.reset();
        events.add(event);
    }

    public static void reload() {
        dB.log("Reloading script events...");
        for (ScriptContainer container : worldContainers) {
            YamlConfiguration config = container.getConfigurationSection("events");
            if (config == null) {
                dB.echoError("Missing or invalid events block for " + container.getName());
                continue;
            }
            for (StringHolder evt : config.getKeys(false)) {
                if (evt == null || evt.str == null) {
                    dB.echoError("Missing or invalid events block for " + container.getName());
                    continue;
                }
                if (!evt.str.contains("@")) continue;
                dB.echoError("Script '" + container.getName() + "' has event '" + evt.str.replace("@", "<R>@<W>") + "' which contains object notation, which is deprecated for use in world events. Please remove it.");
            }
        }
        for (ScriptEvent event : events) {
            event.destroy();
            event.eventPaths.clear();
            boolean matched = false;
            for (ScriptContainer container : worldContainers) {
                YamlConfiguration config = container.getConfigurationSection("events");
                if (config == null) {
                    dB.echoError("Missing or invalid events block for " + container.getName());
                    continue;
                }
                for (StringHolder evt1 : config.getKeys(false)) {
                    String evt = evt1.str.substring(3);
                    if (!ScriptEvent.couldMatchScript(event, container, evt)) continue;
                    event.eventPaths.add(new ScriptPath(container, evt));
                    dB.log("Event match, " + event.getName() + " matched for '" + evt + "'!");
                    matched = true;
                }
            }
            if (!matched) continue;
            event.sort();
            event.init();
        }
    }

    public static boolean matchesScript(ScriptEvent sEvent, ScriptContainer script, String event) {
        if (!script.getContents().getString("enabled", "true").equalsIgnoreCase("true")) {
            return false;
        }
        String cancelmode = ScriptEvent.getSwitch(event, "cancelled");
        if (cancelmode != null && cancelmode.equalsIgnoreCase("false") && sEvent.cancelled) {
            return false;
        }
        if (cancelmode != null && cancelmode.equalsIgnoreCase("true") && !sEvent.cancelled) {
            return false;
        }
        if (!ScriptEvent.checkSwitch(event, "ignorecancelled", "true") && sEvent.cancelled) {
            return false;
        }
        return sEvent.matches(script, event);
    }

    public static boolean couldMatchScript(ScriptEvent sEvent, ScriptContainer script, String event) {
        return sEvent.couldMatch(script, event);
    }

    public void sort() {
        for (ScriptPath path : this.eventPaths) {
            String gotten = ScriptEvent.getSwitch(path.event, "priority");
            path.priority = gotten == null ? 0 : aH.getIntegerFrom(gotten);
        }
        Collections.sort(this.eventPaths, new Comparator<ScriptPath>(){

            @Override
            public int compare(ScriptPath scriptPath, ScriptPath t1) {
                int rel = scriptPath.priority - t1.priority;
                return rel < 0 ? -1 : (rel > 0 ? 1 : 0);
            }
        });
    }

    public void init() {
    }

    public void destroy() {
    }

    public static boolean checkSwitch(String event, String switcher, String value) {
        for (String possible : CoreUtilities.split(event, ' ')) {
            List<String> split = CoreUtilities.split(possible, ':', 2);
            if (!split.get(0).equalsIgnoreCase(switcher) || split.size() <= 1 || split.get(1).equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public static String getSwitch(String event, String switcher) {
        for (String possible : CoreUtilities.split(event, ' ')) {
            List<String> split = CoreUtilities.split(possible, ':', 2);
            if (!split.get(0).equalsIgnoreCase(switcher) || split.size() <= 1) continue;
            return split.get(1);
        }
        return null;
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.equalsIgnoreCase("cancelled")) {
            dB.echoDebug((Debuggable)container, "Event cancelled!");
            this.cancelled = true;
        } else if (determination.equalsIgnoreCase("cancelled:false")) {
            dB.echoDebug((Debuggable)container, "Event uncancelled!");
            this.cancelled = false;
        } else {
            dB.echoError("Unknown determination '" + determination + "'");
            return false;
        }
        return true;
    }

    public HashMap<String, dObject> getContext() {
        return new HashMap<String, dObject>();
    }

    public ScriptEntryData getScriptEntryData() {
        return DenizenCore.getImplementation().getEmptyScriptEntryData();
    }

    public abstract boolean couldMatch(ScriptContainer var1, String var2);

    public abstract boolean matches(ScriptContainer var1, String var2);

    public abstract String getName();

    public void reset() {
        this.cancelled = false;
    }

    public void fire() {
        ++this.fires;
        for (ScriptPath path : this.eventPaths) {
            try {
                if (!ScriptEvent.matchesScript(this, path.container, path.event)) continue;
                this.run(path.container, path.event);
            }
            catch (Exception e) {
                dB.echoError("Handling script " + path.container.getName() + " path:" + path.event + ":::");
                dB.echoError(e);
            }
        }
    }

    public void run(ScriptContainer script, String event) throws CloneNotSupportedException {
        ++this.scriptFires;
        HashMap<String, dObject> context = this.getContext();
        dB.echoDebug((Debuggable)script, "<Y>Running script event '<A>" + this.getName() + "<Y>', event='<A>" + event + "<Y>'" + " for script '<A>" + script.getName() + "<Y>'");
        for (Map.Entry<String, dObject> obj : context.entrySet()) {
            dB.echoDebug((Debuggable)script, "<Y>Context '<A>" + obj.getKey() + "<Y>' = '<A>" + obj.getValue().identify() + "<Y>'");
        }
        List<ScriptEntry> entries = script.getEntries(this.getScriptEntryData(), "events.on " + event);
        long id = DetermineCommand.getNewId();
        ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(script.getName())).addEntries(entries).setReqId(id);
        HashMap<String, dObject> oldStyleContext = this.getContext();
        if (oldStyleContext.size() > 0) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = oldStyleContext;
            oecs.contexts.put("cancelled", new Element(this.cancelled));
            queue.setContextSource(oecs);
        } else {
            queue.setContextSource(this.clone());
        }
        queue.start();
        this.nanoTimes += System.nanoTime() - queue.startTime;
        List<String> determinations = DetermineCommand.getOutcome(id);
        if (determinations != null) {
            for (String determination : determinations) {
                this.applyDetermination(script, determination);
            }
        }
    }

    @Override
    public boolean getShouldCache() {
        return false;
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("cancelled")) {
            return new Element(this.cancelled);
        }
        return null;
    }

    public static class ScriptPath {
        ScriptContainer container;
        String event;
        int priority = 0;

        public ScriptPath(ScriptContainer container, String event) {
            this.container = container;
            this.event = event;
        }
    }
}

