/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSmartEvent
implements OldSmartEvent,
Listener {
    List<CommandHandlerData> cmds = new ArrayList<CommandHandlerData>();

    @Override
    public boolean shouldInitialize(Set<String> events) {
        this.cmds = new ArrayList<CommandHandlerData>();
        boolean pass = false;
        for (String event : events) {
            Matcher m = Pattern.compile("on( ([^\\s]+))? command(in \\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            String cmd = m.group(2);
            if (cmd != null) {
                dList split = dList.valueOf(cmd);
                for (String str : split) {
                    this.cmds.add(new CommandHandlerData(CoreUtilities.toLowerCase(str), cmd));
                }
            }
            pass = true;
        }
        return pass;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Command SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerCommandPreprocessEvent.getHandlerList().unregister((Listener)this);
        ServerCommandEvent.getHandlerList().unregister((Listener)this);
    }

    private List<String> getAll(String cmd) {
        ArrayList<String> newEvents = new ArrayList<String>();
        cmd = CoreUtilities.toLowerCase(cmd);
        for (CommandHandlerData chd : this.cmds) {
            if (!chd.name.equalsIgnoreCase(cmd)) continue;
            newEvents.add(chd.event + " command");
        }
        return newEvents;
    }

    @EventHandler
    public void playerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String message = event.getMessage();
        String command = message.split(" ")[0].replace("/", "").toUpperCase();
        ArrayList<String> events = new ArrayList<String>();
        events.add("command");
        events.add(command + " command");
        events.addAll(this.getAll(command));
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getPlayer().getLocation());
        dList cuboid_context = new dList();
        ArrayList<String> cuboidEvents = new ArrayList<String>();
        for (dCuboid cuboid : cuboids) {
            for (String str : events) {
                cuboidEvents.add(str + " in " + cuboid.identifySimple());
            }
            cuboid_context.add(cuboid.identifySimple());
        }
        events.addAll(cuboidEvents);
        context.put("cuboids", cuboid_context);
        List<String> args = Arrays.asList(aH.buildArgs(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        context.put("args", new dList(args));
        context.put("parsed_args", new dList(args));
        context.put("command", new Element(command));
        context.put("raw_args", new Element(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        context.put("server", Element.FALSE);
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context).toUpperCase();
        if (determination.equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void serverCommand(ServerCommandEvent event) {
        if (event.getCommand().trim().length() == 0) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String message = event.getCommand();
        String command = event.getCommand().split(" ")[0].replace("/", "").toUpperCase();
        ArrayList<String> events = new ArrayList<String>();
        events.add("command");
        events.add(command + " command");
        events.addAll(this.getAll(command));
        List<String> args = Arrays.asList(aH.buildArgs(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        List<String> parsed_args = Arrays.asList(aH.buildArgs(event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("args", new dList(args));
        context.put("parsed_args", new dList(parsed_args));
        context.put("command", new Element(command));
        context.put("raw_args", new Element(message.split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("server", Element.TRUE);
        String determination = BukkitWorldScriptHelper.doEvents(events, null, null, context);
        if (determination.equalsIgnoreCase("FULFILLED") || determination.equalsIgnoreCase("CANCELLED")) {
            event.setCommand("denizen do_nothing");
        }
    }

    class CommandHandlerData {
        public final String name;
        public final String event;

        public CommandHandlerData(String name, String event) {
            this.name = name;
            this.event = event;
        }
    }
}

