/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.plugin.Plugin;

public class EntityUnleashedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityUnleashedScriptEvent instance;
    public dEntity entity;
    public Element reason;
    public EntityUnleashEvent event;

    public EntityUnleashedScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "unleashed");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.tryEntity(this.entity, CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        if (lower.contains("because") && !CoreUtilities.xthArgEquals(3, lower, CoreUtilities.toLowerCase(this.reason.asString()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    public String getName() {
        return "EntityUnleashed";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        EntityUnleashEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityUnleashed(EntityUnleashEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.reason = new Element(event.getReason().toString());
        this.event = event;
        this.fire();
    }
}

