/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.plugin.Plugin;

public class ItemEnchantedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemEnchantedScriptEvent instance;
    public dEntity entity;
    public dLocation location;
    public dInventory inventory;
    public dItem item;
    public Element button;
    public int cost;
    public EnchantItemEvent event;

    public ItemEnchantedScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("enchanted");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String itemTest = CoreUtilities.getXthArg(0, lower);
        if (!itemTest.equals("item") && !this.tryItem(this.item, itemTest)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "ItemEnchanted";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        EnchantItemEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesInteger(determination)) {
            this.cost = aH.getIntegerFrom(determination);
        }
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("inventory")) {
            return this.inventory;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("button")) {
            return this.button;
        }
        if (name.equals("cost")) {
            return new Element(this.cost);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onItemEnchanted(EnchantItemEvent event) {
        this.entity = new dEntity((Entity)event.getEnchanter());
        this.location = new dLocation(event.getEnchantBlock().getLocation());
        this.inventory = dInventory.mirrorBukkitInventory(event.getInventory());
        this.item = new dItem(event.getItem());
        this.button = new Element(event.whichButton());
        this.cost = event.getExpLevelCost();
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setExpLevelCost(this.cost);
    }
}

