/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;

public class PlayerFishesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerFishesScriptEvent instance;
    public dEntity hook;
    public Element state;
    public dEntity entity;
    public dItem item;
    public PlayerFishEvent event;

    public PlayerFishesScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player fishes");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String fish = CoreUtilities.getXthArg(2, lower);
        if (this.entity != null && !fish.isEmpty() && !this.tryEntity(this.entity, fish)) {
            return false;
        }
        List<String> data = CoreUtilities.split(lower, ' ');
        for (int index = 0; index < data.size(); ++index) {
            if (!data.get(index).equals("while") || data.get(index + 1).equalsIgnoreCase(this.state.asString())) continue;
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.hook.getLocation());
    }

    public String getName() {
        return "PlayerFishes";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerFishEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : (dEntity.isPlayer(this.event.getCaught()) ? dEntity.getPlayerFrom(this.event.getCaught()) : null), dEntity.isCitizensNPC((Entity)this.event.getPlayer()) ? dEntity.getNPCFrom((Entity)this.event.getPlayer()) : (dEntity.isCitizensNPC(this.event.getCaught()) ? dEntity.getNPCFrom(this.event.getCaught()) : null));
    }

    public dObject getContext(String name) {
        if (name.equals("hook")) {
            return this.hook;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item") && this.item != null) {
            return this.item;
        }
        if (name.equals("state")) {
            return this.state;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerFishes(PlayerFishEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Fish hookEntity = event.getHook();
        dEntity.rememberEntity((Entity)hookEntity);
        this.hook = new dEntity((Entity)hookEntity);
        this.state = new Element(event.getState().toString());
        this.item = null;
        this.entity = null;
        Entity caughtEntity = event.getCaught();
        if (caughtEntity != null) {
            dEntity.rememberEntity(caughtEntity);
            this.entity = new dEntity(caughtEntity);
            if (caughtEntity instanceof Item) {
                this.item = new dItem(((Item)caughtEntity).getItemStack());
            }
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        dEntity.forgetEntity((Entity)hookEntity);
        dEntity.forgetEntity(caughtEntity);
        event.setCancelled(this.cancelled);
    }
}

