/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.entity.DenizenEntityType;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.plugin.Plugin;

public class PlayerStatisticIncrementsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerStatisticIncrementsScriptEvent instance;
    public Statistic statistic;
    public Integer previous_value;
    public Integer new_value;
    public dMaterial material = null;
    public dEntity entity = null;
    public PlayerStatisticIncrementEvent event;

    public PlayerStatisticIncrementsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player statistic");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String stat = CoreUtilities.getXthArg(2, lower);
        return stat.equals(CoreUtilities.toLowerCase(this.statistic.toString())) || stat.equals("increments");
    }

    public String getName() {
        return "PlayerStatisticIncrements";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerStatisticIncrementEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dPlayer.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    public dObject getContext(String name) {
        if (name.equals("statistic")) {
            return new Element(this.statistic.toString());
        }
        if (name.equals("previous_value")) {
            return new Element(this.previous_value);
        }
        if (name.equals("new_value")) {
            return new Element(this.new_value);
        }
        if (name.equals("qualifier")) {
            if (this.statistic.getType() == Statistic.Type.BLOCK || this.statistic.getType() == Statistic.Type.ITEM) {
                return this.material;
            }
            if (this.statistic.getType() == Statistic.Type.ENTITY) {
                return this.entity;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerStatisticIncrements(PlayerStatisticIncrementEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = null;
        this.entity = null;
        this.previous_value = null;
        this.statistic = event.getStatistic();
        if (this.statistic.getType() == Statistic.Type.BLOCK || this.statistic.getType() == Statistic.Type.ITEM) {
            this.material = dMaterial.getMaterialFrom(event.getMaterial());
        } else if (this.statistic.getType() == Statistic.Type.ENTITY) {
            this.entity = new dEntity(DenizenEntityType.getByName(event.getEntityType().name()));
        }
        this.previous_value = event.getPreviousValue();
        this.new_value = event.getNewValue();
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

