/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;

public class LeafDecaysScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LeafDecaysScriptEvent instance;
    public dLocation location;
    public dMaterial material;
    public LeavesDecayEvent event;

    public LeafDecaysScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.getXthArg(1, lower).equals("decay");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(0, lower);
        return (mat.equals("leaves") || this.tryMaterial(this.material, mat)) && this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "LeafDecays";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        LeavesDecayEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLeafDecays(LeavesDecayEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

