/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class ItemPotion
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getItemStack().getType() == Material.POTION;
    }

    public static ItemPotion getFrom(dObject _item) {
        if (!ItemPotion.describes(_item)) {
            return null;
        }
        return new ItemPotion((dItem)_item);
    }

    private ItemPotion(dItem item) {
        this.item = item;
    }

    public String getPropertyString() {
        Potion pot;
        if (this.item.getItemStack().getDurability() == 0) {
            return null;
        }
        if ((this.item.getItemStack().getDurability() & 0x40) != 0 && PotionType.getByDamageValue((int)(this.item.getItemStack().getDurability() & 0xF)).isInstant()) {
            this.item.getItemStack().setDurability((short)(this.item.getItemStack().getDurability() & 0xFFFFFFBF));
        }
        if ((pot = Potion.fromItemStack((ItemStack)this.item.getItemStack())) == null || pot.getType() == null) {
            return String.valueOf(this.item.getItemStack().getDurability());
        }
        return pot.getType().name() + "," + pot.getLevel() + "," + pot.hasExtendedDuration() + "," + pot.isSplash();
    }

    public String getPropertyId() {
        return "potion";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_potion_effect")) {
            return new Element(this.item.getItemStack().getDurability() > 0).getAttribute(attribute.fulfill(1));
        }
        if (this.item.getItemStack().getDurability() > 0 && attribute.startsWith("potion_effect")) {
            if ((attribute = attribute.fulfill(1)).startsWith("is_splash")) {
                return new Element(Potion.fromItemStack((ItemStack)this.item.getItemStack()).isSplash()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_extended")) {
                return new Element(Potion.fromItemStack((ItemStack)this.item.getItemStack()).hasExtendedDuration()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("level")) {
                return new Element(Potion.fromItemStack((ItemStack)this.item.getItemStack()).getLevel()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("type")) {
                return new Element(Potion.fromItemStack((ItemStack)this.item.getItemStack()).getType().name()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("data")) {
                return new Element(this.item.getItemStack().getDurability()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getPropertyString()).getAttribute(attribute);
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion")) {
            String[] data = mechanism.getValue().asString().split(",", 4);
            if (data.length < 4) {
                if (mechanism.getValue().isInt()) {
                    this.item.getItemStack().setDurability((short)mechanism.getValue().asInt());
                } else {
                    dB.echoError("Invalid effect format, use name,amplifier,extended,splash.");
                }
            } else {
                PotionType type;
                Element data1 = new Element(data[1]);
                Element data2 = new Element(data[2]);
                Element data3 = new Element(data[3]);
                try {
                    type = PotionType.valueOf((String)data[0].toUpperCase());
                }
                catch (Exception ex) {
                    dB.echoError("Invalid potion effect type '" + data[0] + "'");
                    return;
                }
                if (type == null) {
                    dB.echoError("Invalid potion effect type '" + data[0] + "'");
                    return;
                }
                if (!data1.isInt()) {
                    dB.echoError("Cannot apply effect '" + data[0] + "': '" + data[1] + "' is not a valid integer!");
                    return;
                }
                if (!data2.isBoolean()) {
                    dB.echoError("Cannot apply effect '" + data[0] + "': '" + data[2] + "' is not a valid boolean!");
                    return;
                }
                if (!data3.isBoolean()) {
                    dB.echoError("Cannot apply effect '" + data[0] + "': '" + data[3] + "' is not a valid boolean!");
                    return;
                }
                Potion pot = new Potion(type);
                int d1 = data1.asInt();
                if (d1 >= 1 && d1 <= pot.getType().getMaxLevel()) {
                    pot.setLevel(d1);
                }
                if (!pot.getType().isInstant()) {
                    pot.setHasExtendedDuration(data2.asBoolean());
                }
                pot.setSplash(data3.asBoolean());
                this.item.setDurability((short)0);
                pot.apply(this.item.getItemStack());
            }
        }
    }
}

