/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LeashHitch;

public class LeashCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel", "stop")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("holder") && arg.matchesPrefix("holder", "h")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("holder", arg.asType(dEntity.class));
                    continue;
                }
                if (!arg.matchesArgumentType(dLocation.class)) continue;
                scriptEntry.addObject("holder", arg.asType(dLocation.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("cancel")) {
            scriptEntry.defaultObject("holder", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity() : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity() : null);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dEntity holder = null;
        dLocation holderLoc = null;
        Entity Holder2 = null;
        Object holderObject = scriptEntry.getObject("holder");
        if (holderObject instanceof dEntity) {
            holder = (dEntity)scriptEntry.getObject("holder");
            Holder2 = holder.getBukkitEntity();
        } else if (holderObject instanceof dLocation) {
            holderLoc = (dLocation)scriptEntry.getObject("holder");
            if (holderLoc.getBlock().getType() == Material.FENCE || holderLoc.getBlock().getType() == Material.NETHER_FENCE || holderLoc.getBlock().getType() == Material.ACACIA_FENCE || holderLoc.getBlock().getType() == Material.BIRCH_FENCE || holderLoc.getBlock().getType() == Material.JUNGLE_FENCE || holderLoc.getBlock().getType() == Material.DARK_OAK_FENCE || holderLoc.getBlock().getType() == Material.SPRUCE_FENCE) {
                Holder2 = holderLoc.getWorld().spawn((Location)holderLoc, LeashHitch.class);
            } else {
                dB.echoError(scriptEntry.getResidingQueue(), "Bad holder location specified - only fences are permitted!");
                return;
            }
        }
        Boolean cancel = scriptEntry.hasObject("cancel");
        dB.report(scriptEntry, this.getName(), (cancel != false ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("entities", entities.toString()) + (holder != null ? aH.debugObj("holder", holder) : aH.debugObj("holder", holderLoc)));
        for (dEntity entity : entities) {
            if (!entity.isSpawned() || !entity.isLivingEntity()) continue;
            if (cancel.booleanValue()) {
                entity.getLivingEntity().setLeashHolder(null);
                continue;
            }
            entity.getLivingEntity().setLeashHolder(Holder2);
        }
    }
}

