/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Velocity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand
implements Listener,
Holdable {
    Map<UUID, dEntity> arrows = new HashMap<UUID, dEntity>();

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "s")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("originEntity", arg.asType(dEntity.class));
                    continue;
                }
                if (arg.matchesArgumentType(dLocation.class)) {
                    scriptEntry.addObject("originLocation", arg.asType(dLocation.class));
                    continue;
                }
                dB.echoError("Ignoring unrecognized argument: " + arg.raw_value);
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("destination", "d")) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("lead") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("lead")) {
                scriptEntry.addObject("lead", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("height", "h")) {
                scriptEntry.addObject("height", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && (arg.matchesArgumentType(dScript.class) || arg.matchesPrefix("script"))) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("shooter") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("shooter")) {
                scriptEntry.addObject("shooter", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("gravity") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("gravity", "g")) {
                scriptEntry.addObject("gravity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("spread") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("spread")) {
                scriptEntry.addObject("spread", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("no_rotate") && arg.matches("no_rotate")) {
                scriptEntry.addObject("no_rotate", new Element(true));
                continue;
            }
            if (arg.matchesPrefix("def", "define", "context")) {
                scriptEntry.addObject("definitions", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("originLocation")) {
            scriptEntry.defaultObject("originEntity", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity() : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity() : null);
        }
        scriptEntry.defaultObject("height", new Element(3));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("originEntity") && !scriptEntry.hasObject("originLocation")) {
            throw new InvalidArgumentsException("Must specify an origin location!");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation destination;
        boolean no_rotate;
        dEntity originEntity = (dEntity)scriptEntry.getObject("originEntity");
        dLocation originLocation = scriptEntry.hasObject("originLocation") ? (dLocation)scriptEntry.getObject("originLocation") : new dLocation(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()));
        boolean bl = no_rotate = scriptEntry.hasObject("no_rotate") && scriptEntry.getElement("no_rotate").asBoolean();
        dLocation dLocation2 = scriptEntry.hasObject("destination") ? (dLocation)scriptEntry.getObject("destination") : (originEntity != null ? new dLocation(originEntity.getEyeLocation().clone().add(originEntity.getEyeLocation().clone().getDirection().multiply(30))) : (destination = originLocation != null ? new dLocation(originLocation.clone().add(originLocation.getDirection().multiply(30))) : null));
        if (destination == null) {
            dB.report(scriptEntry, this.getName(), "No destination specified!");
            return;
        }
        final List entities = (List)scriptEntry.getObject("entities");
        final dScript script = (dScript)scriptEntry.getObject("script");
        final dList definitions = (dList)scriptEntry.getObject("definitions");
        dEntity shooter = (dEntity)scriptEntry.getObject("shooter");
        Element height = scriptEntry.getElement("height");
        Element gravity = scriptEntry.getElement("gravity");
        Element speed = scriptEntry.getElement("speed");
        Element spread = scriptEntry.getElement("spread");
        dLocation lead = (dLocation)scriptEntry.getObject("lead");
        dB.report(scriptEntry, this.getName(), aH.debugObj("origin", originEntity != null ? originEntity : originLocation) + aH.debugObj("entities", entities.toString()) + destination.debug() + height.debug() + (gravity != null ? gravity.debug() : "") + (speed != null ? speed.debug() : "") + (script != null ? script.debug() : "") + (shooter != null ? shooter.debug() : "") + (spread != null ? spread.debug() : "") + (lead != null ? lead.debug() : "") + (no_rotate ? aH.debugObj("no_rotate", "true") : "") + (definitions != null ? definitions.debug() : ""));
        final dList entityList = new dList();
        for (dEntity entity : entities) {
            if (!entity.isSpawned() || !no_rotate) {
                entity.spawnAt(originLocation);
            }
            entityList.add(entity.toString());
            if (!no_rotate) {
                Rotation.faceLocation(entity.getBukkitEntity(), (Location)destination);
            }
            if (!entity.isProjectile() || shooter == null && originEntity == null) continue;
            entity.setShooter(shooter != null ? shooter : originEntity);
            this.arrows.put(entity.getUUID(), null);
        }
        scriptEntry.addObject("shot_entities", entityList);
        if (spread == null) {
            Position.mount(Conversion.convertEntities(entities));
        }
        final dEntity lastEntity = (dEntity)entities.get(entities.size() - 1);
        if (gravity == null) {
            gravity = new Element(lastEntity.getEntityType().getGravity());
        }
        if (speed == null) {
            Vector v1 = lastEntity.getLocation().toVector();
            Vector v2 = destination.toVector();
            Vector v3 = Velocity.calculate(v1, v2, gravity.asDouble(), height.asDouble());
            lastEntity.setVelocity(v3);
        } else if (lead == null) {
            Vector relative = destination.clone().subtract((Location)originLocation).toVector();
            lastEntity.setVelocity(relative.normalize().multiply(speed.asDouble()));
        } else {
            double g = 20.0;
            double v = speed.asDouble();
            Vector relative = destination.clone().subtract((Location)originLocation).toVector();
            double testAng = Velocity.launchAngle(originLocation, destination.toVector(), v, relative.getY(), g);
            double hangTime = Velocity.hangtime(testAng, v, relative.getY(), g);
            Vector to = destination.clone().add(lead.clone().multiply(hangTime)).toVector();
            relative = to.clone().subtract(originLocation.toVector());
            Double dist = Math.sqrt(relative.getX() * relative.getX() + relative.getZ() * relative.getZ());
            if (dist == 0.0) {
                dist = 0.1;
            }
            testAng = Velocity.launchAngle(originLocation, to, v, relative.getY(), g);
            relative.setY(Math.tan(testAng) * dist);
            relative = relative.normalize();
            relative = relative.multiply((v += 1.188 * Math.pow(hangTime, 2.0)) / 20.0);
            lastEntity.setVelocity(relative);
        }
        if (spread != null) {
            Vector base = lastEntity.getVelocity().clone();
            float sf = spread.asFloat();
            for (dEntity entity : entities) {
                Vector newvel = Velocity.spread(base, (double)(CoreUtilities.getRandom().nextDouble() > 0.5 ? 1 : -1) * Math.toRadians(CoreUtilities.getRandom().nextDouble() * (double)sf), (double)(CoreUtilities.getRandom().nextDouble() > 0.5 ? 1 : -1) * Math.toRadians(CoreUtilities.getRandom().nextDouble() * (double)sf));
                entity.setVelocity(newvel);
            }
        }
        BukkitRunnable task = new BukkitRunnable(){
            boolean flying = true;
            dLocation lastLocation = null;
            Vector lastVelocity = null;

            public void run() {
                if (!lastEntity.isSpawned()) {
                    this.flying = false;
                } else if (this.lastVelocity != null && this.lastVelocity.distance(lastEntity.getBukkitEntity().getVelocity()) < 0.05) {
                    this.flying = false;
                }
                if (!this.flying) {
                    this.cancel();
                    if (script != null) {
                        List<ScriptEntry> entries = script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
                        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(script.getContainer().getName())).addEntries(entries);
                        queue.addDefinition("location", this.lastLocation.identify());
                        queue.addDefinition("shot_entities", entityList.toString());
                        queue.addDefinition("last_entity", lastEntity.identify());
                        dList hitEntities = new dList();
                        for (dEntity entity : entities) {
                            if (!ShootCommand.this.arrows.containsKey(entity.getUUID())) continue;
                            dEntity hit = ShootCommand.this.arrows.get(entity.getUUID());
                            ShootCommand.this.arrows.remove(entity.getUUID());
                            if (hit == null) continue;
                            hitEntities.add(hit.identify());
                        }
                        queue.addDefinition("hit_entities", hitEntities.identify());
                        if (definitions != null) {
                            int x = 1;
                            String[] definition_names = null;
                            try {
                                definition_names = script.getContainer().getString("definitions").split("\\|");
                            }
                            catch (Exception hit) {
                                // empty catch block
                            }
                            for (String definition : definitions) {
                                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                                queue.addDefinition(name, definition);
                                dB.echoDebug((Debuggable)scriptEntry, "Adding definition %" + name + "% as " + definition);
                                ++x;
                            }
                        }
                        queue.start();
                    }
                    scriptEntry.setFinished(true);
                } else {
                    this.lastLocation = lastEntity.getLocation();
                    this.lastVelocity = lastEntity.getVelocity();
                }
            }
        };
        task.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 0L, 2L);
    }

    @EventHandler
    public void arrowDamage(EntityDamageByEntityEvent event) {
        Entity arrow = event.getDamager();
        if (!(arrow instanceof Projectile)) {
            return;
        }
        if (!this.arrows.containsKey(arrow.getUniqueId())) {
            return;
        }
        this.arrows.remove(arrow.getUniqueId());
        this.arrows.put(arrow.getUniqueId(), new dEntity(event.getEntity()));
    }
}

