/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.AbstractMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class InventoryCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnumList(Action.values())) {
                scriptEntry.addObject("actions", arg.asType(dList.class).filter(Action.values()));
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "items", "item", "i", "from", "f") && (arg.matchesArgumentTypes(dInventory.class, dEntity.class, dLocation.class) || arg.matchesArgumentList(dItem.class))) {
                scriptEntry.addObject("origin", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination", "dest", "d", "target", "to", "t") && arg.matchesArgumentTypes(dInventory.class, dEntity.class, dLocation.class)) {
                scriptEntry.addObject("destination", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot, s") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify an Inventory action!");
        }
        scriptEntry.defaultObject("slot", new Element(1)).defaultObject("destination", ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? new AbstractMap.SimpleEntry<Integer, dInventory>(0, ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity().getInventory()) : null);
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must specify a Destination Inventory!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List actions = (List)scriptEntry.getObject("actions");
        AbstractMap.SimpleEntry originentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("origin");
        dInventory origin = originentry != null ? (dInventory)originentry.getValue() : null;
        AbstractMap.SimpleEntry destinationentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("destination");
        dInventory destination = (dInventory)destinationentry.getValue();
        Element slot = scriptEntry.getElement("slot");
        dB.report(scriptEntry, this.getName(), aH.debugObj("actions", actions.toString()) + destination.debug() + (origin != null ? origin.debug() : "") + slot.debug());
        for (String action : actions) {
            switch (Action.valueOf(action.toUpperCase())) {
                case OPEN: {
                    if (destination.getIdType().equals("workbench") || destination.getIdHolder().equalsIgnoreCase("workbench")) {
                        ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().openWorkbench(null, true);
                        break;
                    }
                    ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().openInventory(destination.getInventory());
                    break;
                }
                case CLOSE: {
                    ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().closeInventory();
                    break;
                }
                case COPY: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    origin.replace(destination);
                    break;
                }
                case MOVE: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    origin.replace(destination);
                    origin.clear();
                    break;
                }
                case SWAP: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    dInventory temp = new dInventory(destination.getInventory());
                    origin.replace(destination);
                    temp.replace(origin);
                    break;
                }
                case ADD: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.add(slot.asInt() - 1, origin.getContents());
                    break;
                }
                case REMOVE: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.remove(origin.getContents());
                    break;
                }
                case SET: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.setSlots(slot.asInt() - 1, origin.getContents(), (Integer)originentry.getKey());
                    break;
                }
                case KEEP: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.keep(origin.getContents());
                    break;
                }
                case EXCLUDE: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.exclude(origin.getContents());
                    break;
                }
                case FILL: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.fill(origin.getContents());
                    break;
                }
                case CLEAR: {
                    destination.clear();
                    break;
                }
                case UPDATE: {
                    if (destination.update()) break;
                    dB.echoError("Only player inventories can be force-updated!");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        OPEN,
        CLOSE,
        COPY,
        MOVE,
        SWAP,
        ADD,
        REMOVE,
        SET,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR,
        UPDATE;

    }
}

