/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.entity.Player;

public class ExperienceCommand
extends AbstractCommand {
    public static int getTotalExperience(Player p) {
        return ExperienceCommand.getTotalExperience(p.getLevel(), p.getExp());
    }

    public static int getTotalExperience(int level, double bar) {
        return ExperienceCommand.getTotalExpToLevel(level) + (int)((double)ExperienceCommand.getExpToLevel(level + 1) * bar + 0.5);
    }

    public static int getExpToLevel(int level) {
        if (level < 16) {
            return 17;
        }
        if (level < 31) {
            return 3 * level - 31;
        }
        return 7 * level - 155;
    }

    public static int getTotalExpToLevel(int level) {
        if (level < 16) {
            return 17 * level;
        }
        if (level < 31) {
            return (int)(1.5 * (double)level * (double)level - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * (double)level * (double)level - 151.5 * (double)level + 2220.0);
    }

    public static void resetExperience(Player player) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
    }

    public static void setTotalExperience(Player player, int exp) {
        ExperienceCommand.resetExperience(player);
        if (exp > 0) {
            player.giveExp(exp);
        }
    }

    public static void setLevel(Player player, int level) {
        ExperienceCommand.resetExperience(player);
        if (level > 0) {
            player.giveExp(ExperienceCommand.getExpToLevel(level));
        }
    }

    public static void giveExperience(Player player, int exp) {
        int currentExp = ExperienceCommand.getTotalExperience(player);
        ExperienceCommand.resetExperience(player);
        int newexp = currentExp + exp;
        if (newexp > 0) {
            player.giveExp(newexp);
        }
    }

    public static int countLevel(int exp, int toLevel, int level) {
        if (exp < toLevel) {
            return level;
        }
        return ExperienceCommand.countLevel(exp - toLevel, ExperienceCommand.getTotalExpToLevel(level + 2) - ExperienceCommand.getTotalExpToLevel(level + 1), ++level);
    }

    public static void setSilentTotalExperience(Player player, int exp) {
        ExperienceCommand.resetExperience(player);
        if (exp > 0) {
            int level = ExperienceCommand.countLevel(exp, 17, 0);
            player.setLevel(level);
            int expToLvl = exp - ExperienceCommand.getTotalExpToLevel(level);
            player.setExp(expToLvl < 0 ? 0.0f : (float)(expToLvl / ExperienceCommand.getExpToLevel(level + 1)));
        }
    }

    public static void giveSilentExperience(Player player, int exp) {
        int currentExp = ExperienceCommand.getTotalExperience(player);
        ExperienceCommand.resetExperience(player);
        int newexp = currentExp + exp;
        if (newexp > 0) {
            int level = ExperienceCommand.countLevel(newexp, 17, 0);
            player.setLevel(level);
            int expToLvl = newexp - ExperienceCommand.getTotalExpToLevel(level);
            player.setExp(expToLvl < 0 ? 0.0f : (float)expToLvl / (float)ExperienceCommand.getExpToLevel(level + 1));
        }
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int amount = 0;
        Type type = Type.SET;
        boolean level = false;
        boolean silent = false;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                amount = arg.asElement().asInt();
                continue;
            }
            if (arg.matches("SET", "GIVE", "TAKE")) {
                type = Type.valueOf(arg.asElement().asString().toUpperCase());
                continue;
            }
            if (arg.matches("LEVEL")) {
                level = true;
                continue;
            }
            if (arg.matches("SILENT")) {
                silent = true;
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.addObject("quantity", amount).addObject("type", (Object)type).addObject("level", level).addObject("silent", silent);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Integer quantity = (Integer)scriptEntry.getObject("quantity");
        Boolean level = (Boolean)scriptEntry.getObject("level");
        Boolean silent = (Boolean)scriptEntry.getObject("silent");
        dB.report(scriptEntry, this.name, aH.debugObj("Type", type.toString()) + aH.debugObj("Quantity", level != false ? quantity.toString() + " levels" : quantity.toString()) + aH.debugObj("Player", ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getName()));
        Player player = ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity();
        switch (type) {
            case SET: {
                if (level.booleanValue()) {
                    ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().setLevel(quantity);
                    break;
                }
                if (!silent.booleanValue()) {
                    ExperienceCommand.setTotalExperience(player, quantity);
                    break;
                }
                ExperienceCommand.setSilentTotalExperience(player, quantity);
                break;
            }
            case GIVE: {
                if (level.booleanValue()) {
                    ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().setLevel(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().getLevel() + quantity);
                    break;
                }
                if (!silent.booleanValue()) {
                    ExperienceCommand.giveExperience(player, quantity);
                    break;
                }
                ExperienceCommand.giveSilentExperience(player, quantity);
                break;
            }
            case TAKE: {
                if (level.booleanValue()) {
                    int value = ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().getLevel() - quantity;
                    ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().setLevel(value <= 0 ? 0 : value);
                    break;
                }
                if (!silent.booleanValue()) {
                    ExperienceCommand.giveExperience(player, -quantity.intValue());
                    break;
                }
                ExperienceCommand.giveSilentExperience(player, -quantity.intValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SET,
        GIVE,
        TAKE;

    }
}

