/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BukkitWorldScriptHelper
implements Listener {
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public BukkitWorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(List<String> events, dNPC npc, dPlayer player, Map<String, dObject> context) {
        return BukkitWorldScriptHelper.doEvents(events, npc, player, context, false);
    }

    public static String doEvents(List<String> events, dNPC npc, dPlayer player, Map<String, dObject> context, boolean useids) {
        List<String> determ = useids ? OldEventManager.doEvents(events, new BukkitScriptEntryData(player, npc), context, true) : OldEventManager.doEvents(events, new BukkitScriptEntryData(player, npc), context);
        return determ.size() > 0 ? determ.get(0) : "none";
    }

    public void serverStartEvent() {
        long ticks = Settings.worldScriptTimeEventFrequency().getTicks();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                BukkitWorldScriptHelper.this.timeEvent();
            }
        }, ticks, ticks);
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("server start"), null, null, null);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            Bukkit.getServer().shutdown();
        }
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            dWorld currentWorld;
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey((currentWorld = new dWorld(world)).identifySimple()) && this.current_time.get(currentWorld.identifySimple()) == hour) continue;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("time", new Element(hour));
            context.put("world", currentWorld);
            BukkitWorldScriptHelper.doEvents(Arrays.asList("time changes", "time changes in " + currentWorld.identifySimple(), String.valueOf(hour) + ":00 in " + currentWorld.identifySimple(), "time " + String.valueOf(hour) + " in " + currentWorld.identifySimple()), null, null, context, true);
            this.current_time.put(currentWorld.identifySimple(), hour);
        }
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        dItem holding;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(Material.AIR);
        dInventory inventory = dInventory.mirrorBukkitInventory(event.getInventory());
        final dPlayer player = dEntity.getPlayerFrom((Entity)((Player)event.getWhoClicked()));
        String type = event.getInventory().getType().name();
        String click = event.getClick().name();
        String slotType = event.getSlotType().name();
        ArrayList<String> events = new ArrayList<String>();
        events.add("player clicks in inventory");
        events.add("player clicks in " + type);
        events.add("player clicks in " + inventory.identifySimple());
        String interaction = "player " + click + " clicks ";
        events.add(interaction + "in inventory");
        events.add(interaction + "in " + type);
        events.add(interaction + "in " + inventory.identifySimple());
        if (event.getCursor() != null) {
            holding = new dItem(event.getCursor());
            context.put("cursor_item", holding);
            events.add(interaction + "in inventory with " + holding.identifySimple());
            events.add(interaction + "in " + type + " with " + holding.identifySimple());
            events.add(interaction + "in " + inventory.identifySimple() + " with " + holding.identifySimple());
            events.add(interaction + "in inventory with " + holding.identifyMaterial());
            events.add(interaction + "in " + type + " with " + holding.identifyMaterial());
            events.add(interaction + "in " + inventory.identifySimple() + " with " + holding.identifyMaterial());
            events.add("player clicks in inventory with " + holding.identifySimple());
            events.add("player clicks in " + type + " with " + holding.identifySimple());
            events.add("player clicks in " + inventory.identifySimple() + " with " + holding.identifySimple());
            events.add("player clicks in inventory with " + holding.identifyMaterial());
            events.add("player clicks in " + type + " with " + holding.identifyMaterial());
            events.add("player clicks in " + inventory.identifySimple() + " with " + holding.identifyMaterial());
        }
        if (event.getCurrentItem() != null) {
            item = new dItem(event.getCurrentItem());
            events.add("player clicks " + item.identifySimple() + " in inventory");
            events.add(interaction + item.identifySimple() + " in inventory");
            events.add("player clicks " + item.identifySimple() + " in " + type);
            events.add(interaction + item.identifySimple() + " in " + type);
            events.add("player clicks " + item.identifySimple() + " in " + inventory.identifySimple());
            events.add(interaction + item.identifySimple() + " in " + inventory.identifySimple());
            events.add("player clicks " + item.identifyMaterial() + " in inventory");
            events.add(interaction + item.identifyMaterial() + " in inventory");
            events.add("player clicks " + item.identifyMaterial() + " in " + type);
            events.add(interaction + item.identifyMaterial() + " in " + type);
            events.add("player clicks " + item.identifyMaterial() + " in " + inventory.identifySimple());
            events.add(interaction + item.identifyMaterial() + " in " + inventory.identifySimple());
            if (event.getCursor() != null) {
                holding = new dItem(event.getCursor());
                String[] itemStrings = new String[]{item.identifySimple(), item.identifyMaterial()};
                String[] inventoryStrings = new String[]{"inventory", type, inventory.identifySimple()};
                String[] holdingStrings = new String[]{holding.identifySimple(), holding.identifyMaterial()};
                for (String itemString : itemStrings) {
                    for (String inventoryString : inventoryStrings) {
                        for (String holdingString : holdingStrings) {
                            String fullString = itemString + " in " + inventoryString + " with " + holdingString;
                            events.add("player clicks " + fullString);
                            events.add(interaction + fullString);
                        }
                    }
                }
            }
        }
        context.put("item", item);
        context.put("inventory", inventory);
        context.put("click", new Element(click));
        context.put("slot_type", new Element(slotType));
        context.put("slot", new Element(event.getSlot() + 1));
        context.put("raw_slot", new Element(event.getRawSlot() + 1));
        context.put("is_shift_click", new Element(event.isShiftClick()));
        context.put("action", new Element(event.getAction().name()));
        context.put("hotbar_button", new Element(event.getHotbarButton() + 1));
        String determination = BukkitWorldScriptHelper.doEvents(events, null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
            final InventoryHolder holder = event.getInventory().getHolder();
            new BukkitRunnable(){

                public void run() {
                    player.getPlayerEntity().updateInventory();
                    if (holder != null && holder instanceof Player) {
                        ((Player)holder).updateInventory();
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoins(PlayerJoinEvent event) {
        Scoreboard score;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (ScoreboardHelper.viewerMap.containsKey(event.getPlayer().getName()) && (score = ScoreboardHelper.getScoreboard(ScoreboardHelper.viewerMap.get(event.getPlayer().getName()))) != null) {
            event.getPlayer().setScoreboard(score);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final String message = ChatColor.DARK_GREEN + "CHAT: " + event.getPlayer().getName() + ": " + event.getMessage();
        Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                if (dB.record) {
                    dB.log(message);
                }
            }
        }, 1L);
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        String determination;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Action action = event.getAction();
        dItem item = null;
        dPlayer player = dEntity.getPlayerFrom((Entity)event.getPlayer());
        ArrayList<String> events = new ArrayList<String>();
        if (event.getBlockFace() != null && event.getClickedBlock() != null) {
            context.put("relative", new dLocation(event.getClickedBlock().getRelative(event.getBlockFace()).getLocation()));
        }
        String[] interactions = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK ? new String[]{"player left clicks", "player clicks"} : (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK ? new String[]{"player right clicks", "player clicks"} : new String[]{"player stands on"});
        context.put("click_type", new Element(action.name()));
        for (String interaction : interactions) {
            events.add(interaction);
        }
        if (event.hasItem()) {
            item = new dItem(event.getItem());
            context.put("item", item);
            for (String interaction : interactions) {
                events.add(interaction + " with item");
                events.add(interaction + " with " + item.identifySimple());
                events.add(interaction + " with " + item.identifyMaterial());
            }
        }
        if (event.hasBlock()) {
            Block block = event.getClickedBlock();
            dMaterial blockMaterial = dMaterial.getMaterialFrom(block.getType(), block.getData());
            context.put("location", new dLocation(block.getLocation()));
            for (String interaction : interactions) {
                events.add(interaction + " block");
                events.add(interaction + " " + blockMaterial.identifySimple());
            }
            if (event.hasItem()) {
                for (String interaction : interactions) {
                    events.add(interaction + " block with item");
                    events.add(interaction + " block with " + item.identifySimple());
                    events.add(interaction + " block with " + item.identifyMaterial());
                    events.add(interaction + " " + blockMaterial.identifySimple() + " with item");
                    events.add(interaction + " " + blockMaterial.identifySimple() + " with " + item.identifySimple());
                    events.add(interaction + " " + blockMaterial.identifySimple() + " with " + item.identifyMaterial());
                }
            }
            List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getClickedBlock().getLocation());
            dList cuboid_context = new dList();
            for (String interaction : interactions) {
                if (cuboids.size() > 0) {
                    events.add(interaction + " block in notable cuboid");
                    events.add(interaction + ' ' + blockMaterial.identifySimple() + " in notable cuboid");
                }
                for (dCuboid cuboid : cuboids) {
                    events.add(interaction + " block in " + cuboid.identifySimple());
                    events.add(interaction + ' ' + blockMaterial.identifySimple() + " in " + cuboid.identifySimple());
                }
            }
            for (dCuboid cuboid : cuboids) {
                cuboid_context.add(cuboid.identifySimple());
            }
            context.put("cuboids", cuboid_context);
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, null, player, context, true).toUpperCase()).startsWith("CANCELLED:FALSE")) {
            event.setCancelled(false);
        } else if (determination.startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerLogin(PlayerLoginEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        dPlayer.notePlayer((OfflinePlayer)event.getPlayer());
    }
}

