/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.scripts.requirements.RequirementsMode;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractScriptContainer
extends ScriptContainer {
    private String defaultStep = null;
    private List<String> steps = new ArrayList<String>();

    public InteractScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        try {
            Set<StringHolder> keys = this.getConfigurationSection("STEPS").getKeys(false);
            if (keys.isEmpty()) {
                throw new ExceptionInInitializerError("Could not find any STEPS in " + this.getName() + "! Is the type on this script correct?");
            }
            for (StringHolder step1 : keys) {
                String step = step1.str;
                if (step.contains("*")) {
                    YamlConfiguration defaultStepSection = this.getConfigurationSection("STEPS." + step);
                    step = step.replace("*", "");
                    this.set("STEPS." + step, defaultStepSection);
                    this.set("STEPS." + step + "*", null);
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("1")) {
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("DEFAULT")) {
                    this.defaultStep = step;
                }
                this.steps.add(step);
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        if (this.defaultStep == null && this.steps.size() == 1) {
            this.defaultStep = this.steps.get(0);
        }
        if (this.defaultStep == null) {
            throw new ExceptionInInitializerError("Must specify a default step in '" + this.getName() + "'!");
        }
    }

    public List<String> getStepNames() {
        return this.steps;
    }

    public String getDefaultStepName() {
        return this.defaultStep;
    }

    public boolean containsTriggerInStep(String step, Class<? extends AbstractTrigger> trigger) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        return this.contains("STEPS." + step.toUpperCase() + "." + triggerName + " TRIGGER");
    }

    public List<ScriptEntry> getEntriesFor(Class<? extends AbstractTrigger> trigger, dPlayer player, dNPC npc, String id) {
        return this.getEntriesFor(trigger, player, npc, id, false);
    }

    public List<ScriptEntry> getEntriesFor(Class<? extends AbstractTrigger> trigger, dPlayer player, dNPC npc, String id, boolean quiet) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        if (this.contains("STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"))) {
            return this.getEntries(new BukkitScriptEntryData(player, npc), "STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"));
        }
        if (!quiet) {
            dB.echoDebug((Debuggable)this, "No entries in script for " + "STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"));
        }
        return Collections.emptyList();
    }

    public Map<String, String> getIdMapFor(Class<? extends AbstractTrigger> trigger, dPlayer player) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        if (this.contains("STEPS." + step + "." + triggerName + " TRIGGER")) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            try {
                for (StringHolder id : this.getConfigurationSection("STEPS." + step + "." + triggerName + " TRIGGER").getKeys(false)) {
                    if (id.str.equalsIgnoreCase("SCRIPT")) continue;
                    idMap.put(id.str, this.getString("STEPS." + step + "." + triggerName + " TRIGGER." + id.str + ".TRIGGER", ""));
                }
            }
            catch (Exception ex) {
                dB.echoError("Warning: improperly defined " + trigger.getName() + " trigger for script '" + this.getName() + "'!");
            }
            return idMap;
        }
        return Collections.emptyMap();
    }

    public boolean checkSpecificTriggerScriptRequirementsFor(Class<? extends AbstractTrigger> trigger, dPlayer player, dNPC npc, String id) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.checkRequirements(player, npc, "STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()));
    }

    public String getTriggerOptionFor(Class<? extends AbstractTrigger> trigger, dPlayer player, String id, String option) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.getString("STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()) + "." + option.toUpperCase());
    }

    public boolean hasTriggerOptionFor(Class<? extends AbstractTrigger> trigger, dPlayer player, String id, String option) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.contains("STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()) + "." + option.toUpperCase());
    }

    public boolean checkBaseRequirements(dPlayer player, dNPC npc) {
        return this.checkRequirements(player, npc, "");
    }

    public boolean checkRequirements(dPlayer player, dNPC npc, String path) {
        if (path == null) {
            path = "";
        }
        if (path.length() > 0) {
            path = path + ".";
        }
        List<String> requirements = this.getContents().getStringList(path + "REQUIREMENTS.LIST");
        String mode = this.getContents().getString(path + "REQUIREMENTS.MODE", "ALL");
        if (requirements == null || requirements.isEmpty()) {
            return true;
        }
        RequirementsContext context = new RequirementsContext(new RequirementsMode(mode), requirements, this);
        context.attachPlayer(player);
        context.attachNPC(npc);
        return DenizenAPI.getCurrentInstance().getRequirementChecker().check(context);
    }
}

