/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import org.bukkit.Bukkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequirement
implements RegistrationableInstance {
    protected Denizen plugin;
    protected String name;
    public RequirementOptions requirementOptions;

    @Override
    public AbstractRequirement activate() {
        this.plugin = (Denizen)Bukkit.getPluginManager().getPlugin("Denizen");
        return this;
    }

    @Override
    public AbstractRequirement as(String requirementName) {
        this.name = requirementName;
        this.plugin.getRequirementRegistry().register(requirementName, this);
        this.onEnable();
        return this;
    }

    public abstract boolean check(RequirementsContext var1, List<String> var2) throws RequirementCheckException;

    @Override
    public String getName() {
        return this.name;
    }

    public RequirementOptions getOptions() {
        return this.requirementOptions;
    }

    public String getUsageHint() {
        return !this.requirementOptions.USAGE_HINT.equals("") ? this.requirementOptions.USAGE_HINT : "No usage defined! See documentation for more information!";
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onEnable() {
    }

    public AbstractRequirement withOptions(String usageHint, int numberOfRequiredArgs) {
        this.requirementOptions = new RequirementOptions(usageHint, numberOfRequiredArgs);
        return this;
    }

    public class RequirementOptions {
        public String USAGE_HINT = "";
        public int REQUIRED_ARGS = -1;

        public RequirementOptions(String usageHint, int numberOfRequiredArgs) {
            this.USAGE_HINT = usageHint;
            this.REQUIRED_ARGS = numberOfRequiredArgs;
        }
    }
}

