/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dPlugin;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.scripts.commands.core.SQLCommand;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.javaluator.DoubleEvaluator;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ServerTags
implements Listener {
    public ServerTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
        TagManager.registerTagEvents(this);
    }

    @TagManager.TagEvents
    public void mathTag(ReplaceableTagEvent event) {
        if (!event.matches("math", "m")) {
            return;
        }
        try {
            Double evaluation = (Double)new DoubleEvaluator().evaluate(event.getValue());
            event.setReplaced(new Element(String.valueOf(evaluation)).getAttribute(event.getAttributes().fulfill(1)));
        }
        catch (Exception e) {
            dB.echoError("Invalid math tag!");
            event.setReplaced("0.0");
        }
    }

    @TagManager.TagEvents
    public void ternaryTag(ReplaceableTagEvent event) {
        if (!event.matches("ternary", "tern", "t")) {
            return;
        }
        if (!event.hasNameContext()) {
            return;
        }
        if (event.getNameContext().equalsIgnoreCase("true")) {
            event.setReplaced(new Element(event.getValue().trim()).getAttribute(event.getAttributes().fulfill(1)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @TagManager.TagEvents
    public void serverTag(ReplaceableTagEvent event) {
        dList players;
        String flag;
        Object matchPlayer;
        dList plugins;
        dList list;
        Object npc;
        if (!event.matches("server", "svr", "global") || event.replaced()) {
            return;
        }
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("object_is_valid")) {
            dObject o = ObjectFetcher.pickObjectFor(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
            event.setReplaced(new Element(o != null && !(o instanceof Element)).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("has_whitelist")) {
            event.setReplaced(new Element(Bukkit.hasWhitelist()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                event.setReplaced("null");
                return;
            }
            String flag_name = attribute.getContext(1);
            event.setReplaced(new Element(FlagManager.serverHasFlag(flag_name)).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                event.setReplaced("null");
                return;
            }
            String flag_name = attribute.getContext(1);
            attribute.fulfill(1);
            if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                event.setReplaced(new Element(!FlagManager.serverHasFlag(flag_name)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("size") && !FlagManager.serverHasFlag(flag_name)) {
                event.setReplaced(new Element(0).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (FlagManager.serverHasFlag(flag_name)) {
                FlagManager.Flag flag2 = DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flag_name);
                event.setReplaced(new dList(flag2.toString(), true, flag2.values()).getAttribute(attribute));
            }
            return;
        }
        if (attribute.startsWith("list_materials")) {
            dList allMats = new dList();
            for (Material material : Material.values()) {
                allMats.add(material.name());
            }
            event.setReplaced(allMats.getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("list_flags")) {
            void var4_11;
            dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listGlobalFlags());
            Object var4_9 = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                dList dList2 = new dList();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag3 : allFlags) {
                            if (!pattern.matcher(flag3).matches()) continue;
                            dList2.add(flag3);
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String string : allFlags) {
                        if (!CoreUtilities.toLowerCase(string).contains(search)) continue;
                        dList2.add(string);
                    }
                }
            }
            event.setReplaced(var4_11 == null ? allFlags.getAttribute(attribute.fulfill(1)) : var4_11.getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("list_notables")) {
            dList allNotables = new dList();
            if (attribute.hasContext(1)) {
                String string = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Map.Entry<String, Class> typeClass : NotableManager.getReverseClassIdMap().entrySet()) {
                    if (!string.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                    for (Object notable : NotableManager.getAllType(typeClass.getValue())) {
                        allNotables.add(((dObject)notable).identify());
                    }
                    break;
                }
            } else {
                for (Notable notable : NotableManager.notableObjects.values()) {
                    allNotables.add(((dObject)((Object)notable)).identify());
                }
            }
            event.setReplaced(allNotables.getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("start_time")) {
            event.setReplaced(new Duration(Denizen.startTime / 50L).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_allocated")) {
            event.setReplaced(new Element(Runtime.getRuntime().totalMemory()).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_max")) {
            event.setReplaced(new Element(Runtime.getRuntime().maxMemory()).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_free")) {
            event.setReplaced(new Element(Runtime.getRuntime().freeMemory()).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("available_processors")) {
            event.setReplaced(new Element(Runtime.getRuntime().availableProcessors()).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("current_time_millis")) {
            event.setReplaced(new Element(System.currentTimeMillis()).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("has_event") && attribute.hasContext(1)) {
            event.setReplaced(new Element(OldEventManager.eventExists(attribute.getContext(1)) || OldEventManager.eventExists(OldEventManager.StripIdentifiers(attribute.getContext(1)))).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("get_event_handlers") && attribute.hasContext(1)) {
            String eventName = attribute.getContext(1).toUpperCase();
            List<WorldScriptContainer> list2 = OldEventManager.events.get("ON " + eventName);
            List<WorldScriptContainer> EventsTwo = OldEventManager.events.get("ON " + OldEventManager.StripIdentifiers(eventName));
            if (list2 == null && EventsTwo == null) {
                dB.echoError("No world scripts will handle the event '" + eventName + "'");
            } else {
                dList list22 = new dList();
                if (list2 != null) {
                    for (WorldScriptContainer script : list2) {
                        list22.add("s@" + script.getName());
                    }
                }
                if (EventsTwo != null) {
                    for (WorldScriptContainer script : EventsTwo) {
                        if (list22.contains("s@" + script.getName())) continue;
                        list22.add("s@" + script.getName());
                    }
                }
                event.setReplaced(list22.getAttribute(attribute.fulfill(1)));
            }
        }
        if (attribute.startsWith("selected_npc")) {
            npc = ((Citizens)Bukkit.getPluginManager().getPlugin("Citizens")).getNPCSelector().getSelected((CommandSender)Bukkit.getConsoleSender());
            if (npc == null) {
                return;
            }
            event.setReplaced(new dNPC((NPC)npc).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("get_npcs_named") && Depends.citizens != null && attribute.hasContext(1)) {
            dList npcs2 = new dList();
            for (NPC npc2 : CitizensAPI.getNPCRegistry()) {
                if (!npc2.getName().equalsIgnoreCase(attribute.getContext(1))) continue;
                npcs2.add(dNPC.mirrorCitizensNPC(npc2).identify());
            }
            event.setReplaced(npcs2.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("has_file") && attribute.hasContext(1)) {
            event.setReplaced(new Element(new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1)).exists()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_files") && attribute.hasContext(1)) {
            void var7_90;
            File[] files = DenizenAPI.getCurrentInstance().getDataFolder().listFiles();
            if (files == null) {
                return;
            }
            dList dList3 = new dList();
            File[] arr$ = files;
            int len$ = arr$.length;
            boolean bl = false;
            while (var7_90 < len$) {
                File file = arr$[var7_90];
                dList3.add(file.getName());
                ++var7_90;
            }
            event.setReplaced(dList3.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("has_permissions")) {
            event.setReplaced(new Element(Depends.permissions != null && Depends.permissions.isEnabled()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("has_economy")) {
            event.setReplaced(new Element(Depends.economy != null && Depends.economy.isEnabled()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("denizen_version")) {
            event.setReplaced(new Element(DenizenAPI.getCurrentInstance().getDescription().getVersion()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("bukkit_version")) {
            event.setReplaced(new Element(Bukkit.getBukkitVersion()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("version")) {
            event.setReplaced(new Element(Bukkit.getServer().getVersion()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("java_version")) {
            event.setReplaced(new Element(System.getProperty("java.version")).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("max_players")) {
            event.setReplaced(new Element(Bukkit.getServer().getMaxPlayers()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_sql_connections")) {
            list = new dList();
            for (Map.Entry<String, Connection> entry : SQLCommand.connections.entrySet()) {
                try {
                    if (!entry.getValue().isClosed()) {
                        list.add(entry.getKey());
                        continue;
                    }
                    SQLCommand.connections.remove(entry.getKey());
                }
                catch (SQLException e) {
                    dB.echoError(attribute.getScriptEntry().getResidingQueue(), e);
                }
            }
            event.setReplaced(list.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_permission_groups")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return;
            }
            event.setReplaced(new dList(Arrays.asList(Depends.permissions.getGroups())).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_plugin_names")) {
            plugins = new dList();
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                plugins.add(plugin.getName());
            }
            event.setReplaced(plugins.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_scripts")) {
            dList scripts = new dList();
            for (String str : ScriptRegistry._getScriptNames()) {
                scripts.add("s@" + str);
            }
            event.setReplaced(scripts.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("match_player") && attribute.hasContext(1)) {
            matchPlayer = null;
            String string = CoreUtilities.toLowerCase(attribute.getContext(1));
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (CoreUtilities.toLowerCase(player.getName()).equals(string)) {
                    matchPlayer = player;
                    break;
                }
                if (!CoreUtilities.toLowerCase(player.getName()).contains(string) || matchPlayer != null) continue;
                matchPlayer = player;
            }
            if (matchPlayer != null) {
                event.setReplaced(new dPlayer((Player)matchPlayer).getAttribute(attribute.fulfill(1)));
            }
            return;
        }
        if (attribute.startsWith("match_offline_player") && attribute.hasContext(1)) {
            matchPlayer = null;
            String string = CoreUtilities.toLowerCase(attribute.getContext(1));
            for (Map.Entry<String, UUID> entry : dPlayer.getAllPlayers().entrySet()) {
                if (CoreUtilities.toLowerCase(entry.getKey()).equals(string)) {
                    matchPlayer = entry.getValue();
                    break;
                }
                if (!CoreUtilities.toLowerCase(entry.getKey()).contains(string) || matchPlayer != null) continue;
                matchPlayer = entry.getValue();
            }
            if (matchPlayer != null) {
                event.setReplaced(new dPlayer((UUID)matchPlayer).getAttribute(attribute.fulfill(1)));
            }
            return;
        }
        if (attribute.startsWith("get_npcs_assigned") && Depends.citizens != null && attribute.hasContext(1)) {
            dScript script = dScript.valueOf(attribute.getContext(1));
            if (script == null || !(script.getContainer() instanceof AssignmentScriptContainer)) {
                dB.echoError("Invalid script specified.");
            } else {
                dList dList4 = new dList();
                for (NPC npc3 : CitizensAPI.getNPCRegistry()) {
                    if (!npc3.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).hasAssignment() || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).getAssignment().getName().equalsIgnoreCase(script.getName())) continue;
                    dList4.add(dNPC.mirrorCitizensNPC(npc3).identify());
                }
                event.setReplaced(dList4.getAttribute(attribute.fulfill(1)));
                return;
            }
        }
        if (attribute.startsWith("get_online_players_flagged") && attribute.hasContext(1)) {
            flag = attribute.getContext(1);
            dList dList5 = new dList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(new dPlayer(player), flag).size() <= 0) continue;
                dList5.add(new dPlayer(player).identify());
            }
            event.setReplaced(dList5.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("get_players_flagged") && attribute.hasContext(1)) {
            flag = attribute.getContext(1);
            dList dList6 = new dList();
            for (Map.Entry<String, UUID> entry : dPlayer.getAllPlayers().entrySet()) {
                if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(entry.getValue(), flag).size() <= 0) continue;
                dList6.add(new dPlayer(entry.getValue()).identify());
            }
            event.setReplaced(dList6.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("get_spawned_npcs_flagged") && Depends.citizens != null && attribute.hasContext(1)) {
            flag = attribute.getContext(1);
            dList dList7 = new dList();
            for (NPC npc4 : CitizensAPI.getNPCRegistry()) {
                dNPC dNPC2 = dNPC.mirrorCitizensNPC(npc4);
                if (!dNPC2.isSpawned() || !FlagManager.npcHasFlag(dNPC2, flag)) continue;
                dList7.add(dNPC2.identify());
            }
            event.setReplaced(dList7.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("get_npcs_flagged") && Depends.citizens != null && attribute.hasContext(1)) {
            flag = attribute.getContext(1);
            dList dList8 = new dList();
            for (NPC npc5 : CitizensAPI.getNPCRegistry()) {
                dNPC dNPC3 = dNPC.mirrorCitizensNPC(npc5);
                if (!FlagManager.npcHasFlag(dNPC3, flag)) continue;
                dList8.add(dNPC3.identify());
            }
            event.setReplaced(dList8.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_npcs") && Depends.citizens != null) {
            dList npcs = new dList();
            for (NPC npc6 : CitizensAPI.getNPCRegistry()) {
                npcs.add(dNPC.mirrorCitizensNPC(npc6).identify());
            }
            event.setReplaced(npcs.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_worlds")) {
            dList worlds = new dList();
            for (World world : Bukkit.getWorlds()) {
                worlds.add(dWorld.mirrorBukkitWorld(world).identify());
            }
            event.setReplaced(worlds.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_plugins")) {
            plugins = new dList();
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                plugins.add(new dPlugin(plugin).identify());
            }
            event.setReplaced(plugins.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_players")) {
            players = new dList();
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
            }
            event.setReplaced(players.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_online_players")) {
            players = new dList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player).identify());
            }
            event.setReplaced(players.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_offline_players")) {
            players = new dList();
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                if (offlinePlayer.isOnline()) continue;
                players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
            }
            event.setReplaced(players.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_banned_players")) {
            dList banned = new dList();
            for (OfflinePlayer player : Bukkit.getBannedPlayers()) {
                banned.add(dPlayer.mirrorBukkitPlayer(player).identify());
            }
            event.setReplaced(banned.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_ops")) {
            players = new dList();
            for (OfflinePlayer player : Bukkit.getOperators()) {
                players.add(dPlayer.mirrorBukkitPlayer(player).identify());
            }
            event.setReplaced(players.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_online_ops")) {
            players = new dList();
            for (OfflinePlayer player : Bukkit.getOperators()) {
                if (!player.isOnline()) continue;
                players.add(dPlayer.mirrorBukkitPlayer(player).identify());
            }
            event.setReplaced(players.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_offline_ops")) {
            players = new dList();
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                if (!offlinePlayer.isOp() || offlinePlayer.isOnline()) continue;
                players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
            }
            event.setReplaced(players.getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("motd")) {
            event.setReplaced(new Element(Bukkit.getServer().getMotd()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("entity_is_spawned") && attribute.hasContext(1)) {
            dEntity ent = dEntity.valueOf(attribute.getContext(1));
            event.setReplaced(new Element(ent != null && ent.isUnique() && ent.isSpawned() ? "true" : "false").getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("player_is_valid") && attribute.hasContext(1)) {
            event.setReplaced(new Element(dPlayer.playerNameIsValid(attribute.getContext(1))).getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("npc_is_valid") && attribute.hasContext(1)) {
            npc = dNPC.valueOf(attribute.getContext(1));
            event.setReplaced(new Element(npc != null && ((dNPC)npc).isValid()).getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("recent_tps")) {
            list = new dList();
            for (double d : MinecraftServer.getServer().recentTps) {
                list.add(new Element(d).identify());
            }
            event.setReplaced(list.getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("port")) {
            event.setReplaced(new Element(Bukkit.getServer().getPort()).getAttribute(attribute.fulfill(1)));
        }
    }

    public static void adjustServer(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("delete_file") && mechanism.hasValue()) {
            if (!Settings.allowDelete()) {
                dB.echoError("File deletion disabled by administrator.");
                return;
            }
            File file = new File(DenizenAPI.getCurrentInstance().getDataFolder(), value.asString());
            try {
                if (!file.delete()) {
                    dB.echoError("Failed to delete file: returned false");
                }
            }
            catch (Exception e) {
                dB.echoError("Failed to delete file: " + e.getMessage());
            }
        }
        if (mechanism.matches("run_java") && mechanism.hasValue()) {
            if (!Settings.allowRunningJava()) {
                dB.echoError("Java execution disabled by administrator.");
                return;
            }
            DenizenAPI.getCurrentInstance().runtimeCompiler.runString(mechanism.getValue().asString());
        }
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            if (!Settings.allowConsoleRedirection()) {
                dB.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
        if (mechanism.matches("redirect_bukkit_logging") && mechanism.hasValue()) {
            if (!Settings.allowConsoleRedirection()) {
                dB.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                Denizen.logInterceptor.redirectOutput();
            } else {
                Denizen.logInterceptor.standardOutput();
            }
        }
        if (mechanism.matches("reset_event_stats")) {
            for (ScriptEvent se : ScriptEvent.events) {
                se.fires = 0L;
                se.scriptFires = 0L;
                se.nanoTimes = 0L;
            }
        }
        if (mechanism.matches("cleanmem")) {
            System.gc();
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

