/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Duration;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeBlock {
    private static final Map<UUID, Map<dLocation, FakeBlock>> blocks = new HashMap<UUID, Map<dLocation, FakeBlock>>();
    private static final Map<dLocation, FakeBlock> blocksByLocation = new HashMap<dLocation, FakeBlock>();
    private final dPlayer player;
    private final dLocation location;
    private dMaterial material;
    private long cancelTime = -1L;
    private BukkitTask currentTask = null;

    private FakeBlock(dPlayer player, dLocation location) {
        this.player = player;
        this.location = location;
    }

    public static void showFakeBlockTo(List<dPlayer> players, dLocation location, dMaterial material, Duration duration) {
        for (dPlayer player : players) {
            Map<dLocation, FakeBlock> playerBlocks;
            if (!player.isOnline() || !player.isValid()) continue;
            UUID uuid = player.getPlayerEntity().getUniqueId();
            if (!blocks.containsKey(uuid)) {
                blocks.put(uuid, new HashMap());
            }
            if (!(playerBlocks = blocks.get(uuid)).containsKey(location)) {
                playerBlocks.put(location, new FakeBlock(player, location));
            }
            playerBlocks.get(location).updateBlock(material, duration.getTicks());
        }
    }

    public static void stopShowingTo(List<dPlayer> players, final dLocation location) {
        final ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (dPlayer player : players) {
            Map<dLocation, FakeBlock> playerBlocks;
            if (!player.isOnline() || !player.isValid()) continue;
            UUID uuid = player.getPlayerEntity().getUniqueId();
            uuids.add(uuid);
            if (!blocks.containsKey(uuid) || !(playerBlocks = blocks.get(uuid)).containsKey(location)) continue;
            playerBlocks.get(location).cancelBlock();
        }
        new BukkitRunnable(){

            public void run() {
                for (UUID uuid : blocks.keySet()) {
                    Map playerBlocks;
                    if (uuids.contains(uuid) || !(playerBlocks = (Map)blocks.get(uuid)).containsKey(location)) continue;
                    ((FakeBlock)playerBlocks.get(location)).updateBlock();
                }
            }
        }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
    }

    public static Map<UUID, Map<dLocation, FakeBlock>> getBlocks() {
        return blocks;
    }

    private void cancelBlock() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        this.cancelTime = -1L;
        this.material = null;
        this.location.getBlock().getState().update();
        blocks.get(this.player.getOfflinePlayer().getUniqueId()).remove(this.location);
    }

    public void updateBlock() {
        if (this.material != null) {
            this.updateBlock(this.material, this.cancelTime == -1L ? 0L : this.cancelTime - this.location.getWorld().getFullTime());
        }
    }

    private void updateBlock(dMaterial material, long ticks) {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.material = material;
        if (!this.player.hasChunkLoaded(this.location.getChunk())) {
            return;
        }
        this.player.getPlayerEntity().sendBlockChange((Location)this.location, material.getMaterial(), material.getMaterialData().getData());
        if (ticks > 0L) {
            this.cancelTime = this.location.getWorld().getFullTime() + ticks;
            this.currentTask = new BukkitRunnable(){

                public void run() {
                    FakeBlock.this.currentTask = null;
                    if (FakeBlock.this.player.isValid() && FakeBlock.this.player.isOnline()) {
                        FakeBlock.this.cancelBlock();
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), ticks);
        }
    }

    static {
        FakeBlockListeners fakeBlockListeners = new FakeBlockListeners();
    }

    public static class FakeBlockListeners
    implements Listener {
        public FakeBlockListeners() {
            DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        }

        @EventHandler
        public void playerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (blocks.containsKey(uuid)) {
                blocks.remove(uuid);
            }
        }
    }
}

