/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets.intercept;

import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.events.player.PlayerReceivesMessageScriptEvent;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.commands.server.ExecuteCommand;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.PlayerProfileEditor;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.EntityFakePlayer;
import net.aufdemrand.denizen.utilities.entity.HideEntity;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.aufdemrand.denizencore.objects.Element;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityTracker;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.NBTTagList;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketDataSerializer;
import net.minecraft.server.v1_8_R3.PacketPlayOutChat;
import net.minecraft.server.v1_8_R3.PacketPlayOutCustomPayload;
import net.minecraft.server.v1_8_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityPainting;
import net.minecraft.server.v1_8_R3.PacketPlayOutWindowItems;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class PacketOutHandler {
    private static final Field chat_message;
    private static final Field chat_position;
    private static final Field set_slot_windowId;
    private static final Field set_slot_slotId;
    private static final Field set_slot_itemStack;
    private static final Field window_items_windowId;
    private static final Field window_items_itemStackArray;
    private static final Field named_spawn_entityId;
    private static final Field named_spawn_entityUUID;
    private static final Field spawn_entityId;
    private static final Field spawn_living_entityId;
    private static final Field spawn_painting_entityId;
    private static final Field spawn_experience_entityId;
    private static final Field custom_name;
    private static final Field custom_serializer;

    public static boolean handle(final EntityPlayer player, Packet packet) {
        try {
            if (packet instanceof PacketPlayOutChat) {
                if (ExecuteCommand.silencedPlayers.contains(player.getUniqueID())) {
                    return true;
                }
                PacketPlayOutChat cPacket = (PacketPlayOutChat)packet;
                int pos = chat_position.getInt(cPacket);
                if (pos != 2) {
                    PlayerReceivesMessageScriptEvent event = PlayerReceivesMessageScriptEvent.instance;
                    event.message = new Element(((IChatBaseComponent)chat_message.get(cPacket)).c());
                    event.system = new Element(pos == 1);
                    event.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)player.getBukkitEntity());
                    event.cancelled = false;
                    event.fire();
                    return event.cancelled;
                }
            } else if (packet instanceof PacketPlayOutSetSlot) {
                PacketPlayOutSetSlot ssPacket = (PacketPlayOutSetSlot)packet;
                ItemStack itemStack = (ItemStack)set_slot_itemStack.get(ssPacket);
                set_slot_itemStack.set(ssPacket, PacketOutHandler.removeItemScriptLore(itemStack));
            } else if (packet instanceof PacketPlayOutWindowItems) {
                PacketPlayOutWindowItems wiPacket = (PacketPlayOutWindowItems)packet;
                ItemStack[] itemStacks = (ItemStack[])window_items_itemStackArray.get(wiPacket);
                for (int i = 0; i < itemStacks.length; ++i) {
                    itemStacks[i] = PacketOutHandler.removeItemScriptLore(itemStacks[i]);
                }
                window_items_itemStackArray.set(wiPacket, itemStacks);
            } else if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                PacketPlayOutNamedEntitySpawn nesPacket = (PacketPlayOutNamedEntitySpawn)packet;
                int entityId = named_spawn_entityId.getInt(nesPacket);
                if (PacketOutHandler.entityIsHiding(player, entityId)) {
                    return true;
                }
                UUID entityUUID = (UUID)named_spawn_entityUUID.get(nesPacket);
                final Entity entity = ((WorldServer)player.getWorld()).getEntity(entityUUID);
                if (entity instanceof EntityFakePlayer) {
                    player.playerConnection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{(EntityFakePlayer)entity}));
                    Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                        public void run() {
                            player.playerConnection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{(EntityFakePlayer)entity}));
                        }
                    }, 5L);
                }
            } else {
                PacketPlayOutCustomPayload cPacket;
                String name;
                if (packet instanceof PacketPlayOutSpawnEntity) {
                    PacketPlayOutSpawnEntity sePacket = (PacketPlayOutSpawnEntity)packet;
                    int entityId = spawn_entityId.getInt(sePacket);
                    return PacketOutHandler.entityIsHiding(player, entityId);
                }
                if (packet instanceof PacketPlayOutSpawnEntityLiving) {
                    PacketPlayOutSpawnEntityLiving selPacket = (PacketPlayOutSpawnEntityLiving)packet;
                    int entityId = spawn_living_entityId.getInt(selPacket);
                    return PacketOutHandler.entityIsHiding(player, entityId);
                }
                if (packet instanceof PacketPlayOutSpawnEntityPainting) {
                    PacketPlayOutSpawnEntityPainting sepPacket = (PacketPlayOutSpawnEntityPainting)packet;
                    int entityId = spawn_painting_entityId.getInt(sepPacket);
                    return PacketOutHandler.entityIsHiding(player, entityId);
                }
                if (packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                    PacketPlayOutSpawnEntityExperienceOrb seePacket = (PacketPlayOutSpawnEntityExperienceOrb)packet;
                    int entityId = spawn_experience_entityId.getInt(seePacket);
                    return PacketOutHandler.entityIsHiding(player, entityId);
                }
                if (packet instanceof PacketPlayOutPlayerInfo) {
                    PlayerProfileEditor.updatePlayerProfiles((PacketPlayOutPlayerInfo)packet);
                } else if (packet instanceof PacketPlayOutCustomPayload && (name = (String)custom_name.get(cPacket = (PacketPlayOutCustomPayload)packet)).equals("MC|TrList")) {
                    PacketDataSerializer serializer = (PacketDataSerializer)custom_serializer.get(cPacket);
                    PacketDataSerializer newSerializer = new PacketDataSerializer(Unpooled.buffer());
                    newSerializer.writeInt(serializer.readInt());
                    int trades = serializer.readByte();
                    newSerializer.writeByte(trades);
                    for (int i = 0; i < trades; ++i) {
                        ItemStack buyItem1 = serializer.i();
                        newSerializer.a(PacketOutHandler.removeItemScriptLore(buyItem1));
                        ItemStack buyItem3 = serializer.i();
                        newSerializer.a(PacketOutHandler.removeItemScriptLore(buyItem3));
                        boolean hasItem2 = serializer.readBoolean();
                        newSerializer.writeBoolean(hasItem2);
                        if (hasItem2) {
                            ItemStack buyItem2 = serializer.i();
                            newSerializer.a(PacketOutHandler.removeItemScriptLore(buyItem2));
                        }
                        boolean usedMax = serializer.readBoolean();
                        newSerializer.writeBoolean(usedMax);
                        int uses = serializer.readInt();
                        newSerializer.writeInt(uses);
                        int maxUses = serializer.readInt();
                        newSerializer.writeInt(maxUses);
                    }
                    custom_serializer.set(cPacket, newSerializer);
                }
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return false;
    }

    private static ItemStack removeItemScriptLore(ItemStack itemStack) throws Exception {
        if (itemStack != null && itemStack.hasTag() && !itemStack.getTag().isEmpty()) {
            NBTTagCompound tag = itemStack.getTag();
            NBTTagCompound display = tag.getCompound("display");
            NBTTagList lore = (NBTTagList)display.get("Lore");
            if (lore == null || lore.isEmpty()) {
                return itemStack;
            }
            String hash = null;
            for (int i = 0; i < lore.size(); ++i) {
                String line = lore.getString(i);
                if (!line.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                hash = line;
                lore.a(i);
                break;
            }
            if (hash != null) {
                display.set("Lore", (NBTBase)lore);
                tag.set("display", (NBTBase)display);
                tag.setString("Denizen Item Script", hash);
                itemStack.setTag(tag);
            }
        }
        return itemStack;
    }

    private static boolean entityIsHiding(EntityPlayer player, int entityId) {
        UUID playerUUID = player.getUniqueID();
        if (!HideEntity.hiddenEntities.containsKey(playerUUID)) {
            return false;
        }
        EntityTracker tracker = ((WorldServer)player.world).tracker;
        EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(entityId);
        if (entry == null) {
            return false;
        }
        UUID entityUUID = entry.tracker.getUniqueID();
        if (HideEntity.hiddenEntities.get(playerUUID).contains(entityUUID)) {
            entry.clear(player);
            return true;
        }
        return false;
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutChat.class);
        chat_message = fields.get("a");
        chat_position = fields.get("b");
        fields = PacketHelper.registerFields(PacketPlayOutSetSlot.class);
        set_slot_windowId = fields.get("a");
        set_slot_slotId = fields.get("b");
        set_slot_itemStack = fields.get("c");
        fields = PacketHelper.registerFields(PacketPlayOutWindowItems.class);
        window_items_windowId = fields.get("a");
        window_items_itemStackArray = fields.get("b");
        fields = PacketHelper.registerFields(PacketPlayOutNamedEntitySpawn.class);
        named_spawn_entityId = fields.get("a");
        named_spawn_entityUUID = fields.get("b");
        fields = PacketHelper.registerFields(PacketPlayOutSpawnEntity.class);
        spawn_entityId = fields.get("a");
        fields = PacketHelper.registerFields(PacketPlayOutSpawnEntityLiving.class);
        spawn_living_entityId = fields.get("a");
        fields = PacketHelper.registerFields(PacketPlayOutSpawnEntityPainting.class);
        spawn_painting_entityId = fields.get("a");
        fields = PacketHelper.registerFields(PacketPlayOutSpawnEntityExperienceOrb.class);
        spawn_experience_entityId = fields.get("a");
        fields = PacketHelper.registerFields(PacketPlayOutCustomPayload.class);
        custom_name = fields.get("a");
        custom_serializer = fields.get("b");
    }
}

