/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class UtilTags {
    public UtilTags() {
        TagManager.registerTagEvents(this);
    }

    @TagManager.TagEvents
    public void utilTag(ReplaceableTagEvent event) {
        if (!event.matches("util", "u")) {
            return;
        }
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("random")) {
            String stc;
            if ((attribute = attribute.fulfill(1)).startsWith("int")) {
                stc = attribute.getContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("to") && aH.matchesInteger(stc) && aH.matchesInteger(attribute.getContext(1))) {
                    int max;
                    int min = aH.getIntegerFrom(stc);
                    if (min > (max = aH.getIntegerFrom(attribute.getContext(1)))) {
                        int store = min;
                        min = max;
                        max = store;
                    }
                    event.setReplaced(new Element(String.valueOf(CoreUtilities.getRandom().nextInt(max - min + 1) + min)).getAttribute(attribute.fulfill(1)));
                }
            }
            if (attribute.startsWith("decimal") && attribute.hasContext(1)) {
                stc = attribute.getContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("to") && aH.matchesDouble(stc) && aH.matchesDouble(attribute.getContext(1))) {
                    double max;
                    double min = aH.getDoubleFrom(stc);
                    if (min > (max = aH.getDoubleFrom(attribute.getContext(1)))) {
                        double store = min;
                        min = max;
                        max = store;
                    }
                    event.setReplaced(new Element(String.valueOf(CoreUtilities.getRandom().nextDouble() * (max - min) + min)).getAttribute(attribute.fulfill(1)));
                }
            } else if (attribute.startsWith("decimal")) {
                event.setReplaced(new Element(CoreUtilities.getRandom().nextDouble()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("gauss")) {
                event.setReplaced(new Element(CoreUtilities.getRandom().nextGaussian()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("uuid")) {
                event.setReplaced(new Element(UUID.randomUUID().toString()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("duuid")) {
                event.setReplaced(new Element(ScriptQueue.getNextId(attribute.hasContext(1) ? attribute.getContext(1) : "DUUID")).getAttribute(attribute.fulfill(1)));
            }
        } else if (attribute.startsWith("pi")) {
            event.setReplaced(new Element(Math.PI).getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("tau")) {
            event.setReplaced(new Element(Math.PI * 2).getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("date")) {
            Calendar calendar = Calendar.getInstance();
            Date currentDate = new Date();
            SimpleDateFormat format = new SimpleDateFormat();
            if ((attribute = attribute.fulfill(1)).startsWith("time")) {
                if ((attribute = attribute.fulfill(1)).startsWith("twentyfour_hour")) {
                    format.applyPattern("k:mm");
                    event.setReplaced(new Element(format.format(currentDate)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("year")) {
                    event.setReplaced(new Element(calendar.get(1)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("month")) {
                    event.setReplaced(new Element(calendar.get(2) + 1).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("week")) {
                    event.setReplaced(new Element(calendar.get(3)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("day")) {
                    event.setReplaced(new Element(calendar.get(5)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("hour")) {
                    event.setReplaced(new Element(calendar.get(11)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("minute")) {
                    event.setReplaced(new Element(calendar.get(12)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("second")) {
                    event.setReplaced(new Element(calendar.get(13)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("duration")) {
                    event.setReplaced(new Duration(System.currentTimeMillis() / 50L).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("zone")) {
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    event.setReplaced(new Element(tz.getDisplayName(tz.inDaylightTime(currentDate), 0)).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("formatted_zone")) {
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    event.setReplaced(new Element(tz.getDisplayName(tz.inDaylightTime(currentDate), 1)).getAttribute(attribute.fulfill(1)));
                } else {
                    format.applyPattern("K:mm a");
                    event.setReplaced(new Element(format.format(currentDate)).getAttribute(attribute));
                }
            } else if (attribute.startsWith("format") && attribute.hasContext(1)) {
                try {
                    format.applyPattern(attribute.getContext(1));
                    event.setReplaced(format.format(currentDate));
                }
                catch (Exception ex) {
                    dB.echoError("Error: invalid pattern '" + attribute.getContext(1) + "'");
                    dB.echoError(ex);
                }
            } else {
                format.applyPattern("EEE, MMM d, yyyy");
                event.setReplaced(new Element(format.format(currentDate)).getAttribute(attribute));
            }
        }
    }

    public static void adjustSystem(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            if (!DenizenCore.getImplementation().allowConsoleRedirection()) {
                dB.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
    }
}

