/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerEquipsArmorSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            dItem item;
            Matcher m = Pattern.compile("on player (un)?equips ((m@|i@)?\\w+)", 2).matcher(event);
            if (!m.matches()) continue;
            String string = m.group(2);
            if (string.equalsIgnoreCase("armor") || string.equalsIgnoreCase("helmet") || string.equalsIgnoreCase("chestplate") || string.equalsIgnoreCase("leggings") || string.equalsIgnoreCase("boots")) {
                return true;
            }
            if (dMaterial.matches(string)) {
                dMaterial material = dMaterial.valueOf(string);
                if (material == null) continue;
                return this.isArmor(material.getMaterial());
            }
            if (!dItem.matches(string) || (item = dItem.valueOf(string)) == null) continue;
            return this.isArmor(item.getItemStack());
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Player Equips Armor SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
        InventoryDragEvent.getHandlerList().unregister((Listener)this);
        BlockDispenseEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void blockDispense(BlockDispenseEvent event) {
        final ItemStack item = event.getItem();
        final Location location = event.getBlock().getLocation();
        if (this.isArmor(item)) {
            for (final Player player : location.getWorld().getPlayers()) {
                if (dEntity.isNPC((Entity)player) || !Utilities.checkLocation((LivingEntity)player, location, 2.5)) continue;
                final ItemStack[] armor_contents = (ItemStack[])player.getInventory().getArmorContents().clone();
                final Vector velocity = event.getVelocity();
                new BukkitRunnable(){

                    public void run() {
                        ItemStack[] new_armor = player.getInventory().getArmorContents();
                        for (int i = 0; i < new_armor.length; ++i) {
                            ItemStack before = armor_contents[i];
                            ItemStack now = new_armor[i];
                            if (now == null || now.getType() != item.getType() || now.getDurability() != item.getDurability() || before != null && before.getType() != Material.AIR || !PlayerEquipsArmorSmartEvent.this.playerEquipsArmorEvent(player, item, "DISPENSER")) continue;
                            location.getWorld().dropItemNaturally(location, item).setVelocity(velocity);
                            armor_contents[i] = null;
                            player.getInventory().setArmorContents(armor_contents);
                        }
                    }
                }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 0L);
            }
        }
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent event) {
        ItemStack currentItem;
        Inventory inventory;
        dPlayer pl = dEntity.getPlayerFrom((Entity)event.getWhoClicked());
        if (pl == null) {
            return;
        }
        Player player = pl.getPlayerEntity();
        if (!this.didPlayerClickOwnInventory(player, inventory = event.getInventory())) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
            if (item != null && item.getType() != Material.AIR && (cursor == null || cursor.getType() == Material.AIR || this.isArmor(cursor)) && this.playerUnequipsArmorEvent(player, item, "INVENTORY")) {
                event.setCancelled(true);
                return;
            }
            if (cursor != null && cursor.getType() != Material.AIR && this.isArmor(cursor) && this.playerEquipsArmorEvent(player, cursor, "INVENTORY")) {
                event.setCancelled(true);
            }
        } else if (event.getClick().isShiftClick() && item != null && this.isArmor(item) && ((currentItem = player.getInventory().getArmorContents()[3 - this.getArmorTypeNumber(item)]) == null || currentItem.getType() == Material.AIR) && this.playerEquipsArmorEvent(player, item, "INVENTORY")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryDrag(InventoryDragEvent event) {
        Inventory inventory;
        dPlayer pl = dEntity.getPlayerFrom((Entity)event.getWhoClicked());
        if (pl == null) {
            return;
        }
        Player player = pl.getPlayerEntity();
        if (!this.didPlayerClickOwnInventory(player, inventory = event.getInventory())) {
            return;
        }
        ItemStack item = event.getOldCursor();
        if (!this.isArmor(item)) {
            return;
        }
        int[] armor_slots = new int[]{5, 6, 7, 8};
        Set slots = event.getRawSlots();
        for (int slot : armor_slots) {
            ItemStack before;
            if (!slots.contains(slot) || slot - 5 != this.getArmorTypeNumber(item) || (before = inventory.getItem(slot)) != null && before.getType() != Material.AIR || !this.playerEquipsArmorEvent(player, item, "INVENTORY")) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        dPlayer pl = dEntity.getPlayerFrom((Entity)event.getPlayer());
        if (pl == null) {
            return;
        }
        Player player = pl.getPlayerEntity();
        if (event.hasItem()) {
            ItemStack item = event.getItem();
            Action action = event.getAction();
            Block clicked = event.getClickedBlock();
            if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK || !this.isArmor(item) || clicked != null && this.isInteractive(clicked.getType())) {
                return;
            }
            ItemStack currentItem = event.getPlayer().getInventory().getArmorContents()[3 - this.getArmorTypeNumber(item)];
            if ((currentItem == null || currentItem.getType() == Material.AIR) && this.playerEquipsArmorEvent(player, item, "INTERACT")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void entityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        dPlayer pl = dEntity.getPlayerFrom(entity);
        if (pl == null) {
            return;
        }
        final Player player = pl.getPlayerEntity();
        final ItemStack[] oldArmor = player.getInventory().getArmorContents();
        new BukkitRunnable(){

            public void run() {
                if (!player.isValid() || player.isDead()) {
                    return;
                }
                ItemStack[] newArmor = player.getInventory().getArmorContents();
                for (int i = 0; i < 4; ++i) {
                    ItemStack o = oldArmor[i].clone();
                    ItemStack n = newArmor[i].clone();
                    if (o != null) {
                        o.setDurability((short)0);
                        if (n != null) {
                            n.setDurability((short)0);
                        }
                        if ((n == null || !n.equals((Object)o)) && PlayerEquipsArmorSmartEvent.this.playerUnequipsArmorEvent(player, o, "BREAK")) {
                            newArmor[i] = o;
                        }
                    }
                    player.getInventory().setArmorContents(newArmor);
                }
            }
        }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
    }

    private boolean isArmor(ItemStack itemStack) {
        int id = itemStack.getTypeId();
        return id >= 298 && id <= 317;
    }

    private boolean isArmor(Material material) {
        int id = material.getId();
        return id >= 298 && id <= 317;
    }

    private boolean didPlayerClickOwnInventory(Player player, Inventory inventory) {
        InventoryHolder holder = inventory.getHolder();
        InventoryType type = inventory.getType();
        return holder != null && holder.equals(player) && type != InventoryType.ENDER_CHEST && type != InventoryType.WORKBENCH;
    }

    private int getArmorTypeNumber(ItemStack itemStack) {
        return (itemStack.getTypeId() - 298) % 4;
    }

    private String getArmorType(ItemStack itemStack) {
        if (!this.isArmor(itemStack)) {
            return "helmet";
        }
        switch (this.getArmorTypeNumber(itemStack)) {
            case 0: {
                return "helmet";
            }
            case 1: {
                return "chestplate";
            }
            case 2: {
                return "leggings";
            }
            case 3: {
                return "boots";
            }
        }
        return null;
    }

    private boolean isInteractive(Material material) {
        if (material == null || !material.isBlock()) {
            return false;
        }
        switch (material) {
            case DISPENSER: 
            case NOTE_BLOCK: 
            case BED_BLOCK: 
            case CHEST: 
            case WORKBENCH: 
            case FURNACE: 
            case BURNING_FURNACE: 
            case WOODEN_DOOR: 
            case LEVER: 
            case REDSTONE_ORE: 
            case STONE_BUTTON: 
            case JUKEBOX: 
            case CAKE_BLOCK: 
            case DIODE_BLOCK_ON: 
            case DIODE_BLOCK_OFF: 
            case TRAP_DOOR: 
            case FENCE_GATE: 
            case ENCHANTMENT_TABLE: 
            case BREWING_STAND: 
            case DRAGON_EGG: 
            case ENDER_CHEST: 
            case COMMAND: 
            case BEACON: 
            case WOOD_BUTTON: 
            case ANVIL: 
            case TRAPPED_CHEST: 
            case REDSTONE_COMPARATOR_ON: 
            case REDSTONE_COMPARATOR_OFF: 
            case HOPPER: 
            case DROPPER: {
                return true;
            }
        }
        return false;
    }

    private boolean playerEquipsArmorEvent(final Player player, ItemStack item, String reason) {
        dItem armor = new dItem(item);
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("armor", armor);
        context.put("reason", new Element(reason));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player equips armor", "player equips " + this.getArmorType(item), "player equips " + armor.identifySimple(), "player equips " + armor.identifyMaterial()), null, dEntity.getPlayerFrom((Entity)player), context).toUpperCase();
        if (determination.startsWith("CANCELLED")) {
            new BukkitRunnable(){

                public void run() {
                    player.updateInventory();
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
            return true;
        }
        return false;
    }

    private boolean playerUnequipsArmorEvent(final Player player, ItemStack item, String reason) {
        dItem armor = new dItem(item);
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("armor", armor);
        context.put("reason", new Element(reason));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player unequips armor", "player unequips " + this.getArmorType(item), "player unequips " + armor.identifySimple(), "player unequips " + armor.identifyMaterial()), null, dEntity.getPlayerFrom((Entity)player), context).toUpperCase();
        if (determination.startsWith("CANCELLED")) {
            new BukkitRunnable(){

                public void run() {
                    player.updateInventory();
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
            return true;
        }
        return false;
    }
}

