/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.plugin.Plugin;

public class HorseJumpsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HorseJumpsScriptEvent instance;
    public dEntity entity;
    public Element color;
    public Element variant;
    public Float power;
    public HorseJumpEvent event;

    public HorseJumpsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.equals("horse jumps") || lower.endsWith("jumps");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String tamed;
        String lower = CoreUtilities.toLowerCase(s);
        String arg1 = CoreUtilities.getXthArg(0, lower);
        String arg2 = CoreUtilities.getXthArg(1, lower);
        String string = tamed = arg2.equals("jumps") ? arg1 : arg2;
        if (!this.tryEntity(this.entity, tamed) || !tamed.equals(CoreUtilities.toLowerCase(this.variant.toString()))) {
            return false;
        }
        if (CoreUtilities.getXthArg(2, lower).equals("jumps") && !arg1.equals(CoreUtilities.toLowerCase(this.color.toString()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    public String getName() {
        return "HorseJumps";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        HorseJumpEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.power = Float.valueOf(aH.getFloatFrom(determination));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("color")) {
            return this.color;
        }
        if (name.equals("variant")) {
            return this.variant;
        }
        if (name.equals("power")) {
            return new Element(this.power.floatValue());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHorseJumps(HorseJumpEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.color = new Element(event.getEntity().getColor().name());
        this.variant = new Element(event.getEntity().getVariant().name());
        this.power = Float.valueOf(event.getPower());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setPower(this.power.floatValue());
    }
}

