/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.plugin.Plugin;

public class PlayerLevelsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerLevelsScriptEvent instance;
    public int level;
    public PlayerLevelChangeEvent event;

    public PlayerLevelsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player levels up");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        List<String> data = CoreUtilities.split(lower, ' ');
        for (int index = 0; index < data.size(); ++index) {
            if (data.get(index).equals("from") && aH.getIntegerFrom(data.get(index + 1)) != this.event.getOldLevel()) {
                return false;
            }
            if (!data.get(index).equals("to") || aH.getIntegerFrom(data.get(index + 1)) == this.event.getNewLevel()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "PlayerLevels";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        PlayerLevelChangeEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        dEntity player = new dEntity((Entity)this.event.getPlayer());
        return new BukkitScriptEntryData(player.isPlayer() ? player.getDenizenPlayer() : null, null);
    }

    public dObject getContext(String name) {
        if (name.equals("level")) {
            return new Element(this.level);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerLevels(PlayerLevelChangeEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.level = event.getNewLevel();
        this.event = event;
        this.fire();
    }
}

