/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;

public class StructureGrowsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static StructureGrowsScriptEvent instance;
    public dWorld world;
    public dLocation location;
    public Element structure;
    public dList blocks;
    public dList new_materials;
    public StructureGrowEvent event;

    public StructureGrowsScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String block = CoreUtilities.getXthArg(0, lower);
        dMaterial mat = dMaterial.valueOf(block);
        return cmd.equals("grows") && (block.equals("structure") || mat != null && mat.isStructure());
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String struct = CoreUtilities.getXthArg(0, lower);
        if (!(struct.equals("structure") || struct.equals("plant") || struct.equals(CoreUtilities.toLowerCase(this.structure.asString())))) {
            return false;
        }
        if (CoreUtilities.getXthArg(2, lower).equals("from") && !this.event.isFromBonemeal()) {
            return false;
        }
        if (CoreUtilities.getXthArg(2, lower).equals("naturally") && this.event.isFromBonemeal()) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "StructureGrow";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        StructureGrowEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("structure")) {
            return this.structure;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        if (name.equals("new_materials")) {
            return this.new_materials;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        this.world = new dWorld(event.getWorld());
        this.location = new dLocation(event.getLocation());
        this.structure = new Element(event.getSpecies().name());
        this.blocks = new dList();
        this.new_materials = new dList();
        for (BlockState block : event.getBlocks()) {
            this.blocks.add(new dLocation(block.getLocation()).identify());
            this.new_materials.add(dMaterial.getMaterialFrom(block.getType(), block.getRawData()).identify());
        }
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

