/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.examiners.PathBlockExaminer;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.FishingTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.PushableTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.commands.npc.EngageCommand;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.core.NPCTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.FlyingBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.npc.entity.nonliving.FallingBlockController;
import net.citizensnpcs.npc.entity.nonliving.ItemController;
import net.citizensnpcs.npc.entity.nonliving.ItemFrameController;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.Pose;
import net.minecraft.server.v1_9_R1.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.InventoryHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dNPC
implements dObject,
Adjustable,
InventoryHolder {
    private int npcid = -1;
    private final Location locationCache = new Location(null, 0.0, 0.0, 0.0);
    private String prefix = "npc";

    public static dNPC mirrorCitizensNPC(NPC npc) {
        if (dNPCRegistry._isRegistered(npc)) {
            return dNPCRegistry.getDenizen(npc);
        }
        return new dNPC(npc);
    }

    public static dNPC fromEntity(Entity entity) {
        return dNPC.mirrorCitizensNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
    }

    public static dNPC valueOf(String string) {
        return dNPC.valueOf(string, null);
    }

    @Fetchable(value="n")
    public static dNPC valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (aH.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            int id = aH.getIntegerFrom(string);
            if (dNPCRegistry._isRegistered(id)) {
                return dNPCRegistry.getDenizen(id);
            }
            NPC npc = CitizensAPI.getNPCRegistry().getById(id);
            if (npc != null) {
                return new dNPC(npc);
            }
        } else {
            for (NPC test : CitizensAPI.getNPCRegistry()) {
                if (!test.getName().equalsIgnoreCase(string)) continue;
                return new dNPC(test);
            }
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("n@")) {
            return true;
        }
        if (aH.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            NPC npc = CitizensAPI.getNPCRegistry().getById(aH.getIntegerFrom(string));
            if (npc != null) {
                return true;
            }
        } else {
            for (NPC test : CitizensAPI.getNPCRegistry()) {
                if (!test.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getCitizen() != null;
    }

    public dNPC(NPC citizensNPC) {
        if (citizensNPC != null) {
            this.npcid = citizensNPC.getId();
        }
        if (this.npcid >= 0 && !dNPCRegistry._isRegistered(citizensNPC)) {
            dNPCRegistry._registerNPC(this);
        }
    }

    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getEntity()).getHandle();
    }

    public NPC getCitizen() {
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        if (npc == null) {
            // empty if block
        }
        return npc;
    }

    public Entity getEntity() {
        try {
            return this.getCitizen().getEntity();
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC entity. Has this NPC been removed?");
            return null;
        }
    }

    public LivingEntity getLivingEntity() {
        try {
            if (this.getCitizen().getEntity() instanceof LivingEntity) {
                return (LivingEntity)this.getCitizen().getEntity();
            }
            dB.log("Uh oh! Tried to get the living entity of a non-living NPC!");
            return null;
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC livingEntity. Has this NPC been removed?");
            return null;
        }
    }

    public dEntity getDenizenEntity() {
        try {
            return new dEntity(this.getCitizen().getEntity());
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC dEntity. Has this NPC been removed?");
            return null;
        }
    }

    public org.bukkit.inventory.Inventory getInventory() {
        return dNPCRegistry.getInventory(this.getCitizen());
    }

    public dInventory getDenizenInventory() {
        return new dInventory(this);
    }

    public EntityType getEntityType() {
        return this.getCitizen().getEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.npcid;
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public InteractScriptContainer getInteractScript(dPlayer player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScript(this, player, triggerType);
    }

    public InteractScriptContainer getInteractScriptQuietly(dPlayer player, Class<? extends AbstractTrigger> triggerType) {
        boolean db = dB.showDebug;
        dB.showDebug = false;
        InteractScriptContainer script = InteractScriptHelper.getInteractScript(this, player, triggerType);
        dB.showDebug = db;
        return script;
    }

    public void destroy() {
        this.getCitizen().destroy();
    }

    public dLocation getLocation() {
        if (this.isSpawned()) {
            return new dLocation(this.getEntity().getLocation());
        }
        return new dLocation(this.getCitizen().getStoredLocation());
    }

    public dLocation getEyeLocation() {
        if (this.isSpawned() && this.getCitizen().getEntity() instanceof LivingEntity) {
            return new dLocation(((LivingEntity)this.getCitizen().getEntity()).getEyeLocation());
        }
        if (this.isSpawned()) {
            return new dLocation(this.getEntity().getLocation());
        }
        return new dLocation(this.getCitizen().getStoredLocation());
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.getCitizen().getName() + '/' + this.getCitizen().getId();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        return npc != null && npc.isSpawned();
    }

    public String getOwner() {
        if (((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId() == null) {
            return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwner();
        }
        return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId().toString();
    }

    public AssignmentTrait getAssignmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(AssignmentTrait.class)) {
            npc.addTrait(AssignmentTrait.class);
        }
        return (AssignmentTrait)npc.getTrait(AssignmentTrait.class);
    }

    public Equipment getEquipmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Equipment.class)) {
            npc.addTrait(Equipment.class);
        }
        return (Equipment)npc.getTrait(Equipment.class);
    }

    public NicknameTrait getNicknameTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(NicknameTrait.class)) {
            npc.addTrait(NicknameTrait.class);
        }
        return (NicknameTrait)npc.getTrait(NicknameTrait.class);
    }

    public FishingTrait getFishingTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(FishingTrait.class)) {
            npc.addTrait(FishingTrait.class);
        }
        return (FishingTrait)npc.getTrait(FishingTrait.class);
    }

    public HealthTrait getHealthTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(HealthTrait.class)) {
            npc.addTrait(HealthTrait.class);
        }
        return (HealthTrait)npc.getTrait(HealthTrait.class);
    }

    public Inventory getInventoryTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Inventory.class)) {
            npc.addTrait(Inventory.class);
        }
        return (Inventory)npc.getTrait(Inventory.class);
    }

    public PushableTrait getPushableTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(PushableTrait.class)) {
            npc.addTrait(PushableTrait.class);
        }
        return (PushableTrait)npc.getTrait(PushableTrait.class);
    }

    public LookClose getLookCloseTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(LookClose.class)) {
            npc.addTrait(LookClose.class);
        }
        return (LookClose)npc.getTrait(LookClose.class);
    }

    public TriggerTrait getTriggerTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(TriggerTrait.class)) {
            npc.addTrait(TriggerTrait.class);
        }
        return (TriggerTrait)npc.getTrait(TriggerTrait.class);
    }

    public String action(String actionName, dPlayer player, Map<String, dObject> context) {
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return DenizenAPI.getCurrentInstance().getNPCRegistry().getActionHandler().doAction(actionName, this, player, this.getAssignmentTrait().getAssignment(), context);
        }
        return "none";
    }

    public String action(String actionName, dPlayer player) {
        return this.action(actionName, player, null);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "NPC";
    }

    @Override
    public String identify() {
        return "n@" + this.npcid;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public dNPC setPrefix(String prefix) {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof dNPC)) {
            return false;
        }
        return this.getId() == ((dNPC)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        NPC citizen;
        String flag_name;
        Object trait;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_npc")) {
            return Element.TRUE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location") && !this.isSpawned()) {
            return this.getLocation().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eye_location")) {
            return this.getEyeLocation().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_nickname")) {
            NPC citizen2 = this.getCitizen();
            return new Element(citizen2.hasTrait(NicknameTrait.class) && ((NicknameTrait)citizen2.getTrait(NicknameTrait.class)).hasNickname()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name.nickname")) {
            return new Element(this.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)this.getCitizen().getTrait(NicknameTrait.class)).getNickname() : this.getName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_traits")) {
            ArrayList<String> list = new ArrayList<String>();
            for (Trait trait2 : this.getCitizen().getTraits()) {
                list.add(trait2.getName());
            }
            return new dList((List<String>)list).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_trait") && attribute.hasContext(1) && (trait = CitizensAPI.getTraitFactory().getTraitClass(attribute.getContext(1))) != null) {
            return new Element(this.getCitizen().hasTrait((Class)trait)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("pushable") || attribute.startsWith("is_pushable")) {
            return new Element(this.getPushableTrait().isPushable()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_trigger") && attribute.hasContext(1)) {
            if (!this.getCitizen().hasTrait(TriggerTrait.class)) {
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            trait = (TriggerTrait)this.getCitizen().getTrait(TriggerTrait.class);
            return new Element(((TriggerTrait)((Object)trait)).hasTrigger(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("anchor.list") || attribute.startsWith("anchors.list")) {
            ArrayList<String> list = new ArrayList<String>();
            for (Anchor anchor : ((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchors()) {
                list.add(anchor.getName());
            }
            return new dList((List<String>)list).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("has_anchors")) {
            return new Element(((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchors().size() > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("anchor") && attribute.hasContext(1) && ((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)) != null) {
            return new dLocation(((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)).getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            flag_name = attribute.getContext(1);
            return new Element(FlagManager.npcHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            flag_name = attribute.getContext(1);
            if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.npcHasFlag(this, flag_name)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.npcHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(2));
            }
            if (FlagManager.npcHasFlag(this, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(this.getId(), flag_name);
                return new dList(flag.toString(), true, flag.values()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("list_flags")) {
            dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listNPCFlags(this.getId()));
            dList searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new dList();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
            }
            return searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("constant") && attribute.hasContext(1)) {
            if (this.getCitizen().hasTrait(ConstantsTrait.class) && ((ConstantsTrait)this.getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1)) != null) {
                return new Element(((ConstantsTrait)this.getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("has_pose")) {
            if (attribute.hasContext(1)) {
                return new Element(((Poses)this.getCitizen().getTrait(Poses.class)).hasPose(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("pose") || attribute.startsWith("get_pose")) {
            if (attribute.hasContext(1)) {
                Pose pose = ((Poses)this.getCitizen().getTrait(Poses.class)).getPose(attribute.getContext(1));
                return new dLocation((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0, pose.getYaw(), pose.getPitch()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("engaged") || attribute.startsWith("is_engaged")) {
            return new Element(this.isEngaged()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("invulnerable") || attribute.startsWith("vulnerable")) {
            return new Element((Boolean)this.getCitizen().data().get("protected", (Object)true)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new Element(this.getId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            String owner = this.getOwner();
            dPlayer player = null;
            if (!owner.equalsIgnoreCase("server")) {
                player = dPlayer.valueOfInternal(owner, false);
            }
            if (player != null) {
                return player.getAttribute(attribute.fulfill(1));
            }
            return new Element(owner).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_skin")) {
            return new Element(this.getCitizen().data().has("player-skin-name")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skin_blob") && this.getCitizen().data().has("player-skin-textures")) {
            return new Element(this.getCitizen().data().get("player-skin-textures").toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skin") && this.getCitizen().data().has("player-skin-name")) {
            return new Element(this.getCitizen().data().get("player-skin-name").toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            return this.getDenizenInventory().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_spawned")) {
            return new Element(this.isSpawned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_protected")) {
            return new Element(this.getCitizen().isProtected()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("lookclose")) {
            citizen = this.getCitizen();
            if (citizen.hasTrait(LookClose.class)) {
                String lookclose = ((LookClose)citizen.getTrait(LookClose.class)).toString();
                lookclose = lookclose.substring(10, lookclose.length() - 1);
                return new Element(Boolean.valueOf(lookclose)).getAttribute(attribute.fulfill(1));
            }
            return Element.FALSE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.previous_location")) {
            return NPCTags.previousLocations.containsKey(this.getId()) ? NPCTags.previousLocations.get(this.getId()).getAttribute(attribute.fulfill(2)) : null;
        }
        if (attribute.startsWith("teleport_on_stuck")) {
            return new Element(this.getNavigator().getDefaultParameters().stuckAction() == TeleportStuckAction.INSTANCE).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_script")) {
            citizen = this.getCitizen();
            return new Element(citizen.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("script")) {
            citizen = this.getCitizen();
            if (!citizen.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()) {
                return null;
            }
            return new dScript(((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).getAssignment().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("navigator.is_navigating")) {
            return new Element(this.getNavigator().isNavigating()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.speed")) {
            return new Element(this.getNavigator().getLocalParameters().speed()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.range")) {
            return new Element(this.getNavigator().getLocalParameters().range()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.attack_range")) {
            return new Element(this.getNavigator().getLocalParameters().attackRange()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.attack_strategy")) {
            return new Element(this.getNavigator().getLocalParameters().attackStrategy().toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.speed_modifier")) {
            return new Element(this.getNavigator().getLocalParameters().speedModifier()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.base_speed")) {
            return new Element(this.getNavigator().getLocalParameters().baseSpeed()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.avoid_water")) {
            return new Element(this.getNavigator().getLocalParameters().avoidWater()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_location")) {
            return this.getNavigator().getTargetAsLocation() != null ? new dLocation(this.getNavigator().getTargetAsLocation()).getAttribute(attribute.fulfill(2)) : null;
        }
        if (attribute.startsWith("navigator.is_fighting")) {
            return new Element(this.getNavigator().getEntityTarget() != null && this.getNavigator().getEntityTarget().isAggressive()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_type")) {
            return new Element(this.getNavigator().getTargetType() == null ? "null" : this.getNavigator().getTargetType().toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_entity")) {
            return this.getNavigator().getEntityTarget() != null && this.getNavigator().getEntityTarget().getTarget() != null ? new dEntity((Entity)this.getNavigator().getEntityTarget().getTarget()).getAttribute(attribute.fulfill(2)) : null;
        }
        if (attribute.startsWith("type")) {
            return new Element("NPC").getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return this.getEntity() != null ? new dEntity(this).getAttribute(attribute) : new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to an NPC!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("set_assignment") && mechanism.requireObject(dScript.class)) {
            this.getAssignmentTrait().setAssignment(value.asType(dScript.class).getName(), null);
        }
        if (mechanism.matches("remove_assignment")) {
            this.getAssignmentTrait().removeAssignment(null);
        }
        if (mechanism.matches("set_nickname")) {
            this.getNicknameTrait().setNickname(value.asString());
        }
        if (mechanism.matches("remove_nickname")) {
            this.getNicknameTrait().removeNickname();
        }
        if (mechanism.matches("set_entity_type") && mechanism.requireObject(dEntity.class)) {
            this.getCitizen().setBukkitEntityType(value.asType(dEntity.class).getBukkitEntityType());
        }
        if (mechanism.matches("name") || mechanism.matches("set_name")) {
            this.getCitizen().setName(value.asString().length() > 64 ? value.asString().substring(0, 64) : value.asString());
        }
        if (mechanism.matches("owner")) {
            ((Owner)this.getCitizen().getTrait(Owner.class)).setOwner(value.asString());
        }
        if (mechanism.matches("skin_blob")) {
            if (!mechanism.hasValue()) {
                this.getCitizen().data().remove("player-skin-textures");
            } else {
                this.getCitizen().data().setPersistent("player-skin-textures", (Object)mechanism.getValue().asString());
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("skin")) {
            if (!mechanism.hasValue()) {
                this.getCitizen().data().remove("player-skin-name");
            } else {
                this.getCitizen().data().setPersistent("player-skin-name", (Object)mechanism.getValue().asString());
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("item_type") && mechanism.requireObject(dItem.class)) {
            dItem item = mechanism.getValue().asType(dItem.class);
            Material mat = item.getMaterial().getMaterial();
            byte data = item.getMaterial().getData((byte)0);
            switch (this.getEntity().getType()) {
                case DROPPED_ITEM: {
                    ((Item)this.getEntity()).getItemStack().setType(mat);
                    ((ItemController.ItemNPC)this.getEntity()).setType(mat, (int)data);
                    break;
                }
                case ITEM_FRAME: {
                    ((ItemFrame)this.getEntity()).getItem().setType(mat);
                    ((ItemFrameController.ItemFrameNPC)this.getEntity()).setType(mat, (int)data);
                    break;
                }
                case FALLING_BLOCK: {
                    ((FallingBlockController.FallingBlockNPC)this.getEntity()).setType(mat, (int)data);
                    break;
                }
                default: {
                    dB.echoError("NPC is the not an item type!");
                }
            }
        }
        if (mechanism.matches("spawn")) {
            if (mechanism.requireObject("Invalid dLocation specified. Assuming last known NPC location.", dLocation.class)) {
                this.getCitizen().spawn((Location)value.asType(dLocation.class));
            } else {
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().range(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("attack_range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().attackRange((double)mechanism.getValue().asFloat());
        }
        if (mechanism.matches("speed") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().speedModifier(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("despawn")) {
            this.getCitizen().despawn(DespawnReason.PLUGIN);
        }
        if (mechanism.matches("set_protected") && mechanism.requireBoolean()) {
            this.getCitizen().setProtected(value.asBoolean());
        }
        if (mechanism.matches("lookclose") && mechanism.requireBoolean()) {
            this.getLookCloseTrait().lookClose(value.asBoolean());
        }
        if (mechanism.matches("set_examiner")) {
            if (mechanism.getValue().toString().equalsIgnoreCase("default")) {
                this.getNavigator().getLocalParameters().clearExaminers();
                this.getNavigator().getLocalParameters().examiner((BlockExaminer)new MinecraftBlockExaminer());
            } else if (mechanism.getValue().toString().equalsIgnoreCase("fly")) {
                this.getNavigator().getLocalParameters().clearExaminers();
                this.getNavigator().getLocalParameters().examiner((BlockExaminer)new FlyingBlockExaminer());
            } else if (mechanism.getValue().toString().equalsIgnoreCase("path")) {
                this.getNavigator().getLocalParameters().clearExaminers();
                this.getNavigator().getLocalParameters().examiner((BlockExaminer)new PathBlockExaminer(this, null));
            }
        }
        if (mechanism.matches("teleport_on_stuck") && mechanism.requireBoolean()) {
            if (value.asBoolean()) {
                this.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
            } else {
                this.getNavigator().getDefaultParameters().stuckAction(null);
            }
        }
        if (mechanism.matches("set_distance") && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().distanceMargin(mechanism.getValue().asDouble());
        }
        for (Property property : PropertyParser.getProperties(this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            if (this.isSpawned()) {
                new dEntity(this.getEntity()).adjust(mechanism);
            } else {
                mechanism.reportInvalid();
            }
        }
    }
}

