/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.notable;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotableManager {
    public static Map<String, Notable> notableObjects = new ConcurrentHashMap<String, Notable>();
    public static Map<String, Class> typeTracker = new ConcurrentHashMap<String, Class>();
    public static Map<Notable, String> reverseObjects = new ConcurrentHashMap<Notable, String>();
    private FileConfiguration notablesSave = null;
    private File notablesFile = null;
    private static Map<Class, String> objects = new HashMap<Class, String>();
    private static Map<String, Class> reverse_objects = new HashMap<String, Class>();

    public NotableManager() {
        NotableManager.registerWithNotableManager(dCuboid.class);
        NotableManager.registerWithNotableManager(dEllipsoid.class);
        NotableManager.registerWithNotableManager(dInventory.class);
        NotableManager.registerWithNotableManager(dItem.class);
        NotableManager.registerWithNotableManager(dLocation.class);
    }

    public static boolean isSaved(String id) {
        return notableObjects.containsKey(CoreUtilities.toLowerCase(id));
    }

    public static boolean isSaved(Notable object) {
        return reverseObjects.containsKey(object);
    }

    public static Notable getSavedObject(String id) {
        if (notableObjects.containsKey(CoreUtilities.toLowerCase(id))) {
            return notableObjects.get(CoreUtilities.toLowerCase(id));
        }
        return null;
    }

    public static String getSavedId(Notable object) {
        if (reverseObjects.containsKey(object)) {
            return reverseObjects.get(object);
        }
        return null;
    }

    public static boolean isType(String id, Class type) {
        return typeTracker.containsKey(CoreUtilities.toLowerCase(id)) && typeTracker.get(CoreUtilities.toLowerCase(id)) == type;
    }

    public static void saveAs(Notable object, String id) {
        if (object == null) {
            return;
        }
        notableObjects.put(CoreUtilities.toLowerCase(id), object);
        reverseObjects.put(object, CoreUtilities.toLowerCase(id));
        typeTracker.put(CoreUtilities.toLowerCase(id), object.getClass());
    }

    public static void remove(String id) {
        Notable obj = notableObjects.get(CoreUtilities.toLowerCase(id));
        notableObjects.remove(CoreUtilities.toLowerCase(id));
        reverseObjects.remove(obj);
        typeTracker.remove(CoreUtilities.toLowerCase(id));
    }

    public static void remove(Notable obj) {
        String id = reverseObjects.get(obj);
        notableObjects.remove(CoreUtilities.toLowerCase(id));
        reverseObjects.remove(obj);
        typeTracker.remove(CoreUtilities.toLowerCase(id));
    }

    public static <T extends dObject> List<T> getAllType(Class<T> type) {
        ArrayList<dObject> objects = new ArrayList<dObject>();
        for (Map.Entry<String, Notable> notable : notableObjects.entrySet()) {
            if (!NotableManager.isType(notable.getKey(), type)) continue;
            objects.add((dObject)((Object)notable.getValue()));
        }
        return objects;
    }

    private static void _recallNotables() {
        notableObjects.clear();
        typeTracker.clear();
        reverseObjects.clear();
        for (String key : DenizenAPI.getCurrentInstance().notableManager().getNotables().getKeys(false)) {
            Class clazz = reverse_objects.get(key);
            ConfigurationSection section = DenizenAPI.getCurrentInstance().notableManager().getNotables().getConfigurationSection(key);
            if (section == null) continue;
            for (String notable : section.getKeys(false)) {
                Notable obj = (Notable)ObjectFetcher.getObjectFrom(clazz, section.getString(notable));
                if (obj != null) {
                    obj.makeUnique(notable.replace("DOT", "."));
                    continue;
                }
                dB.echoError("Notable '" + section.getString(notable).replace("DOT", ".") + "' failed to load!");
            }
        }
    }

    private static void _saveNotables() {
        FileConfiguration notables = DenizenAPI.getCurrentInstance().notableManager().getNotables();
        for (String string : notables.getKeys(false)) {
            notables.set(string, null);
        }
        for (Map.Entry entry : notableObjects.entrySet()) {
            notables.set(NotableManager.getClassId(NotableManager.getClass((Notable)entry.getValue())) + "." + CoreUtilities.toLowerCase((String)entry.getKey()).replace(".", "DOT"), ((Notable)entry.getValue()).getSaveObject());
        }
    }

    private static <T extends Notable> Class<T> getClass(Notable notable) {
        for (Class clazz : objects.keySet()) {
            if (!clazz.isInstance(notable)) continue;
            return clazz;
        }
        return null;
    }

    public void reloadNotables() {
        if (this.notablesFile == null) {
            this.notablesFile = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "notables.yml");
        }
        this.notablesSave = YamlConfiguration.loadConfiguration((File)this.notablesFile);
        NotableManager._recallNotables();
    }

    public FileConfiguration getNotables() {
        if (this.notablesSave == null) {
            this.reloadNotables();
        }
        return this.notablesSave;
    }

    public void saveNotables() {
        if (this.notablesSave == null || this.notablesFile == null) {
            return;
        }
        try {
            NotableManager._saveNotables();
            this.notablesSave.save(this.notablesFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.notablesFile, ex);
        }
    }

    public static void registerWithNotableManager(Class notable) {
        for (Method method : notable.getMethods()) {
            if (!method.isAnnotationPresent(Note.class)) continue;
            String note = method.getAnnotation(Note.class).value();
            objects.put(notable, note);
            reverse_objects.put(note, notable);
        }
    }

    public static boolean canFetch(Class notable) {
        return objects.containsKey(notable);
    }

    public static String getClassId(Class notable) {
        if (NotableManager.canFetch(notable)) {
            return objects.get(notable);
        }
        return null;
    }

    public static Map<String, Class> getReverseClassIdMap() {
        return reverse_objects;
    }
}

