/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.minecraft.server.v1_9_R1.BiomeBase;
import net.minecraft.server.v1_9_R1.BlockPosition;
import net.minecraft.server.v1_9_R1.Chunk;
import net.minecraft.server.v1_9_R1.Entity;
import net.minecraft.server.v1_9_R1.EntityTypes;
import net.minecraft.server.v1_9_R1.EnumCreatureType;
import net.minecraft.server.v1_9_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_9_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R1.block.CraftBlock;
import org.bukkit.entity.EntityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiomeNMS {
    private final BiomeBase biomeBase;
    private final String name;
    private static final Map<Class<? extends Entity>, Integer> ENTITY_CLASS_ID_MAP;
    private static final Field DOES_RAIN;
    private static final Field DOES_SNOW;
    private static final Field HUMIDITY;
    private static final Field TEMPERATURE;

    public BiomeNMS(Biome biome) {
        this.biomeBase = CraftBlock.biomeToBiomeBase((Biome)biome);
        this.name = CoreUtilities.toLowerCase(biome.name());
    }

    public DownfallType getDownfallType() {
        if (this.getDoesSnow()) {
            return DownfallType.SNOW;
        }
        if (this.getDoesRain()) {
            return DownfallType.RAIN;
        }
        return DownfallType.NONE;
    }

    public String getName() {
        return this.name;
    }

    public float getHumidity() {
        return this.biomeBase.getHumidity();
    }

    public float getTemperature() {
        return this.biomeBase.getTemperature();
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (BiomeBase.BiomeMeta meta : this.biomeBase.getMobs(creatureType)) {
            entityTypes.add(EntityType.fromId((int)ENTITY_CLASS_ID_MAP.get(meta.b)));
        }
        return entityTypes;
    }

    public List<EntityType> getAllEntities() {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.addAll(this.getAmbientEntities());
        entityTypes.addAll(this.getCreatureEntities());
        entityTypes.addAll(this.getMonsterEntities());
        entityTypes.addAll(this.getWaterEntities());
        return entityTypes;
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.AMBIENT);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.CREATURE);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.MONSTER);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.WATER_CREATURE);
    }

    public void setDownfallType(DownfallType type) {
        switch (type) {
            case RAIN: {
                this.setDoesRain(true);
                this.setDoesSnow(false);
                break;
            }
            case SNOW: {
                this.setDoesRain(false);
                this.setDoesSnow(true);
                break;
            }
            case NONE: {
                this.setDoesRain(false);
                this.setDoesSnow(false);
            }
        }
    }

    public void setHumidity(float humidity) {
        try {
            HUMIDITY.set(this.biomeBase, Float.valueOf(humidity));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public void setTemperature(float temperature) {
        try {
            TEMPERATURE.set(this.biomeBase, Float.valueOf(temperature));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public void changeBlockBiome(Location location) {
        Chunk chunk;
        int x = location.getBlockX();
        int z = location.getBlockZ();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        if (world.isLoaded(new BlockPosition(x, 0, z)) && (chunk = world.getChunkAtWorldCoords(new BlockPosition(x, 0, z))) != null) {
            byte[] biomevals = chunk.getBiomeIndex();
            biomevals[(z & 0xF) << 4 | x & 0xF] = (byte)BiomeBase.a((BiomeBase)this.biomeBase);
        }
    }

    private boolean getDoesRain() {
        try {
            return DOES_RAIN.getBoolean(this.biomeBase);
        }
        catch (Exception e) {
            dB.echoError(e);
            return false;
        }
    }

    private boolean getDoesSnow() {
        try {
            return DOES_SNOW.getBoolean(this.biomeBase);
        }
        catch (Exception e) {
            dB.echoError(e);
            return false;
        }
    }

    private void setDoesRain(boolean doesRain) {
        try {
            DOES_RAIN.set(this.biomeBase, doesRain);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    private void setDoesSnow(boolean doesSnow) {
        try {
            DOES_SNOW.set(this.biomeBase, doesSnow);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    static {
        Map map = null;
        Field rains = null;
        Field snows = null;
        Field humidity = null;
        Field temperature = null;
        try {
            Field field = EntityTypes.class.getDeclaredField("f");
            field.setAccessible(true);
            map = (Map)field.get(null);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            rains = BiomeBase.class.getDeclaredField("G");
            rains.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            snows = BiomeBase.class.getDeclaredField("F");
            snows.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            humidity = BiomeBase.class.getDeclaredField("D");
            humidity.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            temperature = BiomeBase.class.getDeclaredField("C");
            temperature.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        ENTITY_CLASS_ID_MAP = map;
        DOES_RAIN = rains;
        DOES_SNOW = snows;
        HUMIDITY = humidity;
        TEMPERATURE = temperature;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownfallType {
        RAIN,
        SNOW,
        NONE;

    }
}

