/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.blocks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Duration;
import net.minecraft.server.v1_9_R1.BlockPosition;
import net.minecraft.server.v1_9_R1.Chunk;
import net.minecraft.server.v1_9_R1.Entity;
import net.minecraft.server.v1_9_R1.EntityHuman;
import net.minecraft.server.v1_9_R1.EnumSkyBlock;
import net.minecraft.server.v1_9_R1.IBlockData;
import net.minecraft.server.v1_9_R1.IWorldAccess;
import net.minecraft.server.v1_9_R1.PlayerChunkMap;
import net.minecraft.server.v1_9_R1.SoundCategory;
import net.minecraft.server.v1_9_R1.SoundEffect;
import net.minecraft.server.v1_9_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_9_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_9_R1.CraftWorld;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BlockLight {
    private static final Method playerChunkMethod;
    private static final Field dirtyCountField;
    private static final Map<Location, BlockLight> lightsByLocation;
    private static final Map<Chunk, List<BlockLight>> lightsByChunk;
    private static final BukkitTask bukkitTask;
    private static final BlockFace[] adjacentFaces;
    private final CraftWorld craftWorld;
    private final WorldServer worldServer;
    private final CraftChunk craftChunk;
    private final Chunk chunk;
    private final Block block;
    private final BlockPosition position;
    private final int originalLight;
    private int currentLight;
    private int cachedLight;
    private BukkitTask removeTask;

    private BlockLight(Location location, Duration duration) {
        this.craftWorld = (CraftWorld)location.getWorld();
        this.worldServer = this.craftWorld.getHandle();
        this.craftChunk = (CraftChunk)location.getChunk();
        this.chunk = this.craftChunk.getHandle();
        this.block = location.getBlock();
        this.position = new BlockPosition(this.block.getX(), this.block.getY(), this.block.getZ());
        this.currentLight = this.originalLight = (int)this.block.getLightLevel();
        this.cachedLight = this.originalLight;
        this.removeLater(duration);
    }

    public static BlockLight createLight(Location location, int lightLevel, Duration duration) {
        BlockLight blockLight;
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            blockLight = lightsByLocation.get(location);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            blockLight.reset(true);
            blockLight.removeLater(duration);
        } else {
            blockLight = new BlockLight(location, duration);
            lightsByLocation.put(location, blockLight);
            if (!lightsByChunk.containsKey(blockLight.chunk)) {
                lightsByChunk.put(blockLight.chunk, new ArrayList());
            }
            lightsByChunk.get(blockLight.chunk).add(blockLight);
        }
        blockLight.update(lightLevel, true);
        return blockLight;
    }

    public static void removeLight(Location location) {
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            BlockLight blockLight = lightsByLocation.get(location);
            blockLight.reset(true);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
            }
            lightsByLocation.remove(location);
            lightsByChunk.get(blockLight.chunk).remove(blockLight);
            if (lightsByChunk.get(blockLight.chunk).isEmpty()) {
                lightsByChunk.remove(blockLight.chunk);
            }
        }
    }

    private void removeLater(Duration duration) {
        long ticks;
        if (duration != null && (ticks = duration.getTicks()) > 0L) {
            this.removeTask = new BukkitRunnable(){

                public void run() {
                    BlockLight.this.removeTask = null;
                    BlockLight.removeLight(BlockLight.this.block.getLocation());
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), ticks);
        }
    }

    private void reset(boolean updateChunk) {
        this.update(this.originalLight, updateChunk);
    }

    private void update(int lightLevel, boolean updateChunk) {
        if (this.currentLight == lightLevel) {
            return;
        }
        if (this.originalLight == lightLevel) {
            this.worldServer.c(EnumSkyBlock.BLOCK, this.position);
        } else {
            this.worldServer.a(EnumSkyBlock.BLOCK, this.position, lightLevel);
            Block adjacentAir = null;
            for (BlockFace face : adjacentFaces) {
                Block possible;
                if (this.position.getY() == 0 && face == BlockFace.DOWN || this.position.getY() == this.craftWorld.getMaxHeight() - 1 && face == BlockFace.UP || (possible = this.block.getRelative(face)).getType() != Material.AIR) continue;
                adjacentAir = possible;
                break;
            }
            if (adjacentAir != null) {
                this.worldServer.w(new BlockPosition(adjacentAir.getX(), adjacentAir.getY(), adjacentAir.getZ()));
            }
            this.cachedLight = lightLevel;
        }
        if (updateChunk) {
            BlockLight.updateChunk(this.chunk, this.worldServer.getPlayerChunkMap());
        }
        this.currentLight = lightLevel;
    }

    private static void updateChunk(Chunk chunk, PlayerChunkMap playerChunkMap) {
        int cX = chunk.locX;
        int cZ = chunk.locZ;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Object pChunk = BlockLight.getPlayerChunk(playerChunkMap, cX + x, cZ + z);
                if (pChunk == null) continue;
                BlockLight.setDirtyCount(pChunk);
            }
        }
    }

    private static Object getPlayerChunk(PlayerChunkMap map, int x, int z) {
        try {
            return playerChunkMethod.invoke((Object)map, x, z, false);
        }
        catch (Exception e) {
            dB.echoError(e);
            return null;
        }
    }

    private static void setDirtyCount(Object playerChunk) {
        try {
            int dirtyCount = dirtyCountField.getInt(playerChunk);
            if (dirtyCount > 0 && dirtyCount < 64) {
                dirtyCountField.set(playerChunk, 64);
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    private static IWorldAccess getIWorldAccess(World world) {
        final PlayerChunkMap map = ((CraftWorld)world).getHandle().getPlayerChunkMap();
        return new IWorldAccess(){

            public void a(net.minecraft.server.v1_9_R1.World world, BlockPosition blockPosition, IBlockData iBlockData, IBlockData iBlockData1, int i) {
            }

            public void a(BlockPosition position) {
                map.flagDirty(position);
            }

            public void b(int arg0, BlockPosition arg1, int arg2) {
            }

            public void a(EntityHuman arg0, int arg1, BlockPosition arg2, int arg3) {
            }

            public void a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            }

            public void a(EntityHuman entityHuman, SoundEffect soundEffect, SoundCategory soundCategory, double v, double v1, double v2, float v3, float v4) {
            }

            public void a(SoundEffect soundEffect, BlockPosition blockPosition) {
            }

            public void a(int arg0, BlockPosition arg1, int arg2) {
            }

            public void a(int arg0, boolean arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7, int ... arg8) {
            }

            public void a(Entity arg0) {
            }

            public void b(Entity arg0) {
            }
        };
    }

    static {
        lightsByLocation = new HashMap<Location, BlockLight>();
        lightsByChunk = new HashMap<Chunk, List<BlockLight>>();
        adjacentFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
        Method pcm = null;
        Field dcf = null;
        try {
            pcm = PlayerChunkMap.class.getDeclaredMethod("a", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            pcm.setAccessible(true);
            dcf = pcm.getReturnType().getDeclaredField("dirtyCount");
            dcf.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        playerChunkMethod = pcm;
        dirtyCountField = dcf;
        for (World worlds : Bukkit.getServer().getWorlds()) {
            WorldServer nmsWorld = ((CraftWorld)worlds).getHandle();
            IWorldAccess access = BlockLight.getIWorldAccess(worlds);
            nmsWorld.addIWorldAccess(access);
        }
        bukkitTask = new BukkitRunnable(){

            public void run() {
                for (Map.Entry entry : lightsByChunk.entrySet()) {
                    List blockLights;
                    Chunk chunk = (Chunk)entry.getKey();
                    if (!chunk.bukkitChunk.isLoaded() || (blockLights = (List)entry.getValue()).isEmpty()) continue;
                    PlayerChunkMap playerChunkMap = ((BlockLight)blockLights.get(0)).worldServer.getPlayerChunkMap();
                    for (BlockLight light : blockLights) {
                        light.reset(false);
                    }
                    BlockLight.updateChunk(chunk, playerChunkMap);
                    for (BlockLight light : blockLights) {
                        light.update(light.cachedLight, false);
                    }
                    BlockLight.updateChunk(chunk, playerChunkMap);
                }
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 5L, 5L);
    }
}

