/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.jnbt;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.aufdemrand.denizen.utilities.jnbt.ByteArrayTag;
import net.aufdemrand.denizen.utilities.jnbt.ByteTag;
import net.aufdemrand.denizen.utilities.jnbt.CompoundTag;
import net.aufdemrand.denizen.utilities.jnbt.DoubleTag;
import net.aufdemrand.denizen.utilities.jnbt.EndTag;
import net.aufdemrand.denizen.utilities.jnbt.FloatTag;
import net.aufdemrand.denizen.utilities.jnbt.IntArrayTag;
import net.aufdemrand.denizen.utilities.jnbt.IntTag;
import net.aufdemrand.denizen.utilities.jnbt.ListTag;
import net.aufdemrand.denizen.utilities.jnbt.LongTag;
import net.aufdemrand.denizen.utilities.jnbt.NBTConstants;
import net.aufdemrand.denizen.utilities.jnbt.NBTUtils;
import net.aufdemrand.denizen.utilities.jnbt.NamedTag;
import net.aufdemrand.denizen.utilities.jnbt.ShortTag;
import net.aufdemrand.denizen.utilities.jnbt.StringTag;
import net.aufdemrand.denizen.utilities.jnbt.Tag;

public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;

    public NBTInputStream(InputStream is) throws IOException {
        this.is = new DataInputStream(is);
    }

    public NamedTag readNamedTag() throws IOException {
        return this.readNamedTag(0);
    }

    private NamedTag readNamedTag(int depth) throws IOException {
        String name;
        int type = this.is.readByte() & 0xFF;
        if (type != 0) {
            int nameLength = this.is.readShort() & 0xFFFF;
            byte[] nameBytes = new byte[nameLength];
            this.is.readFully(nameBytes);
            name = new String(nameBytes, NBTConstants.CHARSET);
        } else {
            name = "";
        }
        return new NamedTag(name, this.readTagPayload(type, depth));
    }

    private Tag readTagPayload(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case 1: {
                return new ByteTag(this.is.readByte());
            }
            case 2: {
                return new ShortTag(this.is.readShort());
            }
            case 3: {
                return new IntTag(this.is.readInt());
            }
            case 4: {
                return new LongTag(this.is.readLong());
            }
            case 5: {
                return new FloatTag(this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(this.is.readDouble());
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new ByteArrayTag(bytes);
            }
            case 8: {
                short length = this.is.readShort();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new StringTag(new String(bytes, NBTConstants.CHARSET));
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.is.readInt();
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                for (int i = 0; i < length; ++i) {
                    Tag tag = this.readTagPayload(childType, depth + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    tagList.add(tag);
                }
                return new ListTag(NBTUtils.getTypeClass(childType), tagList);
            }
            case 10: {
                NamedTag namedTag;
                Tag tag;
                HashMap<String, Tag> tagMap = new HashMap<String, Tag>();
                while (!((tag = (namedTag = this.readNamedTag(depth + 1)).getTag()) instanceof EndTag)) {
                    tagMap.put(namedTag.getName(), tag);
                }
                return new CompoundTag(tagMap);
            }
            case 11: {
                int length = this.is.readInt();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.is.readInt();
                }
                return new IntArrayTag(data);
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    public void close() throws IOException {
        this.is.close();
    }
}

