/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.Iterator;
import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ChooseCommand
extends BracedCommand {
    @Override
    public void onEnable() {
        this.setBraced();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Iterator<aH.Argument> i$ = aH.interpret(scriptEntry.getArguments()).iterator();
        if (i$.hasNext()) {
            aH.Argument arg = i$.next();
            if (!scriptEntry.hasObject("choice")) {
                scriptEntry.addObject("choice", arg.asElement());
                scriptEntry.addObject("braces", ChooseCommand.getBracedCommands(scriptEntry));
            } else {
                arg.reportUnhandled();
            }
        }
        if (!scriptEntry.hasObject("choice")) {
            throw new InvalidArgumentsException("Must have a choice!");
        }
        if (!scriptEntry.hasObject("braces")) {
            throw new InvalidArgumentsException("Must have sub-commands!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element choice = scriptEntry.getElement("choice");
        List bdlist = (List)scriptEntry.getObject("braces");
        if (bdlist == null || bdlist.isEmpty()) {
            dB.echoError(scriptEntry.getResidingQueue(), "Empty sub-commands (internal)!");
            return;
        }
        List<ScriptEntry> bracedCommandsList = ((BracedCommand.BracedData)bdlist.get((int)0)).value;
        dB.report(scriptEntry, this.getName(), choice.debug());
        String choice_low = CoreUtilities.toLowerCase(choice.asString());
        ScriptEntry result = null;
        for (ScriptEntry se : bracedCommandsList) {
            String cmdName = CoreUtilities.toLowerCase(se.getCommandName());
            if (cmdName.equals("default")) {
                result = se;
                break;
            }
            if (cmdName.equals("case")) {
                if (se.getArguments().size() == 1) {
                    String arg = TagManager.tag(se.getArguments().get(0), DenizenCore.getImplementation().getTagContextFor(scriptEntry, false));
                    if (!CoreUtilities.toLowerCase(arg).equals(choice_low)) continue;
                    result = se;
                    break;
                }
                dB.echoError("Unknown choice sub-command '" + se.toString() + "'!");
                continue;
            }
            dB.echoError("Unknown choice sub-command '" + cmdName + "'!");
        }
        if (result == null) {
            dB.echoDebug((Debuggable)scriptEntry, "No result!");
            return;
        }
        List<BracedCommand.BracedData> new_commands = ChooseCommand.getBracedCommands(result);
        if (new_commands == null || new_commands.isEmpty()) {
            dB.echoError(scriptEntry.getResidingQueue(), "Empty case sub-commands (internal)!");
            return;
        }
        List<ScriptEntry> new_command_list = new_commands.get((int)0).value;
        for (int i = 0; i < new_command_list.size(); ++i) {
            new_command_list.get(i).setInstant(true);
            new_command_list.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
        }
        scriptEntry.getResidingQueue().injectEntries(new_command_list, 0);
    }
}

