/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.plugin.Plugin;

public class FurnaceSmeltsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static FurnaceSmeltsItemScriptEvent instance;
    public dItem source_item;
    public dItem result_item;
    public dLocation location;
    public FurnaceSmeltEvent event;

    public FurnaceSmeltsItemScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("furnace smelts");
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String resItem;
        String lower = CoreUtilities.toLowerCase(s);
        String srcItem = CoreUtilities.getXthArg(2, lower);
        if (!this.tryItem(this.source_item, srcItem)) {
            return false;
        }
        if (CoreUtilities.getXthArg(3, lower).equals("into") && !this.tryItem(this.result_item, resItem = CoreUtilities.getXthArg(4, lower))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    public String getName() {
        return "FurnaceSmelts";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        FurnaceSmeltEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.result_item = dItem.valueOf(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("source_item")) {
            return this.source_item;
        }
        if (name.equals("result_item")) {
            return this.result_item;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onFurnaceSmelts(FurnaceSmeltEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.source_item = new dItem(event.getSource());
        this.result_item = new dItem(event.getResult());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setResult(this.result_item.getItemStack());
        event.setCancelled(this.cancelled);
    }
}

