/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPatterns
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        if (item instanceof dItem) {
            Material material = ((dItem)item).getItemStack().getType();
            return material == Material.BANNER || material == Material.WALL_BANNER || material == Material.STANDING_BANNER || material == Material.SHIELD;
        }
        return false;
    }

    public static ItemPatterns getFrom(dObject item) {
        if (!ItemPatterns.describes(item)) {
            return null;
        }
        return new ItemPatterns((dItem)item);
    }

    private ItemPatterns(dItem item) {
        this.item = item;
    }

    private dList listPatterns() {
        dList list = new dList();
        for (Pattern pattern : this.getPatterns()) {
            list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
        }
        return list;
    }

    private List<Pattern> getPatterns() {
        ItemMeta itemMeta = this.item.getItemStack().getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            return ((Banner)((BlockStateMeta)itemMeta).getBlockState()).getPatterns();
        }
        return ((BannerMeta)itemMeta).getPatterns();
    }

    private void setPatterns(List<Pattern> patterns) {
        ItemStack itemStack = this.item.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            Banner banner = (Banner)((BlockStateMeta)itemMeta).getBlockState();
            banner.setPatterns(patterns);
            banner.update();
            ((BlockStateMeta)itemMeta).setBlockState((BlockState)banner);
        } else {
            ((BannerMeta)itemMeta).setPatterns(patterns);
        }
        itemStack.setItemMeta(itemMeta);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("patterns")) {
            return this.listPatterns().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        dList list = this.listPatterns();
        if (list.isEmpty()) {
            return null;
        }
        return list.identify();
    }

    @Override
    public String getPropertyId() {
        return "patterns";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            dList list = mechanism.getValue().asType(dList.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    dB.echoError("Could not apply pattern to banner: " + string);
                }
            }
            this.setPatterns(patterns);
        }
    }
}

