/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.minecraft.server.v1_9_R1.GameProfileSerializer;
import net.minecraft.server.v1_9_R1.ItemStack;
import net.minecraft.server.v1_9_R1.MinecraftServer;
import net.minecraft.server.v1_9_R1.NBTBase;
import net.minecraft.server.v1_9_R1.NBTTagCompound;
import org.bukkit.craftbukkit.v1_9_R1.inventory.CraftItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemSkullskin
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getItemStack().getItemMeta() instanceof SkullMeta;
    }

    public static ItemSkullskin getFrom(dObject _item) {
        if (!ItemSkullskin.describes(_item)) {
            return null;
        }
        return new ItemSkullskin((dItem)_item);
    }

    private ItemSkullskin(dItem _item) {
        this.item = _item;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("skin")) {
            String skin = this.getPropertyString();
            if (this.item.getItemStack().getDurability() == 3 && skin != null) {
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    return new Element(skin).getAttribute(attribute.fulfill(1));
                }
                return new Element(CoreUtilities.split(skin, '|').get(0)).getAttribute(attribute);
            }
            dB.echoError("This skull_item does not have a skin set!");
        }
        if (attribute.startsWith("has_skin")) {
            return new Element(this.item.getItemStack().getDurability() == 3 && this.getPropertyString() != null).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public String getPropertyString() {
        NBTTagCompound tag;
        ItemStack itemStack;
        if (this.item.getItemStack().getDurability() == 3 && (itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)this.item.getItemStack())).hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10)) {
            GameProfile profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"));
            com.mojang.authlib.properties.Property property = Iterables.getFirst(profile.getProperties().get((Object)"textures"), null);
            UUID uuid = profile.getId();
            return (uuid != null ? uuid : profile.getName()) + (property != null ? "|" + property.getValue() + (profile != null && profile.getName() != null ? "|" + profile.getName() : "") : "");
        }
        return null;
    }

    public String getPropertyId() {
        return "skull_skin";
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skull_skin")) {
            GameProfile profile;
            if (this.item.getItemStack().getDurability() != 3) {
                this.item.getItemStack().setDurability((short)3);
            }
            dList list = mechanism.getValue().asType(dList.class);
            String idString = (String)list.get(0);
            ItemStack itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)this.item.getItemStack());
            if (idString.contains("-")) {
                UUID uuid = UUID.fromString(idString);
                String name = null;
                if (list.size() > 2) {
                    name = (String)list.get(2);
                }
                profile = new GameProfile(uuid, name);
            } else {
                profile = new GameProfile(null, idString);
            }
            if (list.size() > 1) {
                profile.getProperties().put((Object)"textures", (Object)new com.mojang.authlib.properties.Property("value", (String)list.get(1)));
            }
            profile = ItemSkullskin.fillGameProfile(profile);
            if (list.size() > 1) {
                profile.getProperties().get((Object)"textures").clear();
                profile.getProperties().put((Object)"textures", (Object)new com.mojang.authlib.properties.Property("value", (String)list.get(1)));
            }
            NBTTagCompound tag = itemStack.hasTag() ? itemStack.getTag() : new NBTTagCompound();
            tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)profile));
            itemStack.setTag(tag);
            this.item.setItemStack(CraftItemStack.asBukkitCopy((ItemStack)itemStack));
        }
    }

    public static GameProfile fillGameProfile(GameProfile gameProfile) {
        block8: {
            try {
                if (gameProfile != null) {
                    GameProfile gameProfile1 = null;
                    if (gameProfile.getId() != null) {
                        gameProfile1 = MinecraftServer.getServer().getUserCache().a(gameProfile.getId());
                    }
                    if (gameProfile1 == null && gameProfile.getName() != null) {
                        gameProfile1 = MinecraftServer.getServer().getUserCache().getProfile(gameProfile.getName());
                    }
                    if (gameProfile1 == null) {
                        gameProfile1 = gameProfile;
                    }
                    if (Iterables.getFirst(gameProfile1.getProperties().get((Object)"textures"), null) == null) {
                        if (dB.verbose) {
                            dB.log("Filling profile name/textures!");
                        }
                        gameProfile1 = MinecraftServer.getServer().ay().fillProfileProperties(gameProfile1, true);
                    }
                    return gameProfile1;
                }
            }
            catch (Exception e) {
                if (!dB.verbose) break block8;
                dB.echoError(e);
            }
        }
        return null;
    }
}

