/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import net.minecraft.server.v1_9_R1.IScoreboardCriteria;
import net.minecraft.server.v1_9_R1.Packet;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_9_R1.Scoreboard;
import net.minecraft.server.v1_9_R1.ScoreboardBaseCriteria;
import net.minecraft.server.v1_9_R1.ScoreboardObjective;
import net.minecraft.server.v1_9_R1.ScoreboardScore;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SidebarCommand
extends AbstractCommand {
    private static final Map<UUID, Sidebar> sidebars = new HashMap<UUID, Sidebar>();
    private static final Scoreboard dummyScoreboard = new Scoreboard();
    private static final IScoreboardCriteria dummyCriteria = new ScoreboardBaseCriteria("dummy");

    public void onEnable() {
        this.setParseArgs(false);
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new SidebarEvents(), (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.SET;
        for (aH.Argument arg : aH.interpret(scriptEntry.getOriginalArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                action = Action.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "t", "objective", "obj", "o")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lines") && arg.matchesPrefix("lines", "line", "l")) {
                scriptEntry.addObject("lines", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("value", "values", "val", "v")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("increment") && arg.matchesPrefix("increment", "inc", "i")) {
                scriptEntry.addObject("increment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("start") && arg.matchesPrefix("start", "s")) {
                scriptEntry.addObject("start", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("players", "player", "p")) {
                scriptEntry.addObject("players", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("per_player") || !arg.matches("per_player")) continue;
            scriptEntry.addObject("per_player", new Element(true));
        }
        if (action == Action.ADD && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) for that action!");
        }
        if (!(action != Action.SET || scriptEntry.hasObject("value") || scriptEntry.hasObject("title") || scriptEntry.hasObject("increment") || scriptEntry.hasObject("start"))) {
            throw new InvalidArgumentsException("Must specify at least one of: value(s), title, increment, or start for that action!");
        }
        if (action == Action.SET && scriptEntry.hasObject("lines") && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) when setting lines!");
        }
        scriptEntry.addObject("action", new Element(action.name()));
        BukkitScriptEntryData entryData = (BukkitScriptEntryData)scriptEntry.entryData;
        scriptEntry.defaultObject("per_player", new Element(false)).defaultObject("players", new Element(entryData.hasPlayer() ? entryData.getPlayer().identify() : "li@"));
    }

    /*
     * Unable to fully structure code
     */
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        action = scriptEntry.getElement("action");
        elTitle = scriptEntry.getElement("title");
        elLines = scriptEntry.getElement("lines");
        elValue = scriptEntry.getElement("value");
        elIncrement = scriptEntry.getElement("increment");
        elStart = scriptEntry.getElement("start");
        elPlayers = scriptEntry.getElement("players");
        elPerPlayer = scriptEntry.getElement("per_player");
        players = dList.valueOf(TagManager.tag(elPlayers.asString(), new BukkitTagContext(scriptEntry, false)));
        per_player = elPerPlayer.asBoolean();
        perTitle = null;
        perLines = null;
        perValue = null;
        perIncrement = null;
        perStart = null;
        title = null;
        lines = null;
        value = null;
        increment = null;
        start = null;
        if (per_player) {
            if (elTitle != null) {
                perTitle = elTitle.asString();
            }
            if (elLines != null) {
                perLines = elLines.asString();
            }
            if (elValue != null) {
                perValue = elValue.asString();
            }
            if (elIncrement != null) {
                perIncrement = elIncrement.asString();
            }
            if (elStart != null) {
                perStart = elStart.asString();
            }
            debug = action.debug() + (elTitle != null ? elTitle.debug() : "") + (elLines != null ? elLines.debug() : "") + (elValue != null ? elValue.debug() : "") + (elIncrement != null ? elIncrement.debug() : "") + (elStart != null ? elStart.debug() : "") + players.debug();
        } else {
            context = (BukkitTagContext)DenizenAPI.getCurrentInstance().getTagContextFor(scriptEntry, false);
            if (elTitle != null) {
                title = new Element(TagManager.tag(elTitle.asString(), context));
            }
            if (elLines != null) {
                lines = dList.valueOf(TagManager.tag(elLines.asString(), context));
            }
            if (elValue != null) {
                value = dList.valueOf(TagManager.tag(elValue.asString(), context));
            }
            if (elIncrement != null) {
                increment = new Element(TagManager.tag(elIncrement.asString(), context));
            }
            if (elStart != null) {
                start = new Element(TagManager.tag(elStart.asString(), context));
            }
            debug = action.debug() + (title != null ? title.debug() : "") + (lines != null ? lines.debug() : "") + (value != null ? value.debug() : "") + (increment != null ? increment.debug() : "") + (start != null ? start.debug() : "") + players.debug();
        }
        dB.report(scriptEntry, this.getName(), debug);
        switch (1.$SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action[Action.valueOf(action.asString()).ordinal()]) {
            case 1: {
                for (dPlayer player : players.filter(dPlayer.class)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC(), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        value = dList.valueOf(TagManager.tag(perValue, context));
                        if (perLines != null) {
                            lines = dList.valueOf(TagManager.tag(perLines, context));
                        }
                    }
                    if (lines == null) ** GOTO lbl72
                    try {
                        for (i = 0; i < lines.size(); ++i) {
                            index = Integer.valueOf((String)lines.get(i)) - 1;
                            line = (String)value.get(i);
                            current.add(index, line);
                        }
                        ** GOTO lbl74
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                        continue;
                    }
lbl72:
                    // 1 sources

                    current.addAll(value);
lbl74:
                    // 2 sources

                    sidebar.setLines(current);
                    sidebar.sendUpdate();
                }
                break;
            }
            case 2: {
                for (dPlayer player : players.filter(dPlayer.class)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC(), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = dList.valueOf(TagManager.tag(perValue, context));
                        }
                        if (perLines != null) {
                            lines = dList.valueOf(TagManager.tag(perLines, context));
                        }
                    }
                    if (lines != null) {
                        try {
                            offset = 0;
                            for (String line : lines) {
                                index = Integer.valueOf(line) - 1 - offset;
                                current.remove(index);
                                ++offset;
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        continue;
                    }
                    if (value != null) {
                        try {
                            it = current.iterator();
                            while (it.hasNext()) {
                                next = it.next();
                                for (String line : value) {
                                    if (!next.equalsIgnoreCase(line)) continue;
                                    it.remove();
                                }
                            }
                            for (String line : value) {
                                for (i = 0; i < current.size(); ++i) {
                                    if (!current.get(i).equalsIgnoreCase(line)) continue;
                                    current.remove(i);
                                }
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        continue;
                    }
                    sidebar.remove();
                }
                break;
            }
            case 3: {
                for (dPlayer player : players.filter(dPlayer.class)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    currEdited = false;
                    if (per_player) {
                        context = new BukkitTagContext(player, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC(), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = dList.valueOf(TagManager.tag(perValue, context));
                        }
                        if (perLines != null) {
                            lines = dList.valueOf(TagManager.tag(perLines, context));
                        }
                        if (perStart != null) {
                            start = new Element(TagManager.tag(perStart, context));
                        }
                        if (perIncrement != null) {
                            increment = new Element(TagManager.tag(perIncrement, context));
                        }
                        if (perTitle != null) {
                            title = new Element(TagManager.tag(perTitle, context));
                        }
                    }
                    if (lines != null) {
                        try {
                            for (i = 0; i < lines.size(); ++i) {
                                index = Integer.valueOf((String)lines.get(i)) - 1;
                                line = (String)value.get(i);
                                if (index > current.size()) {
                                    current.add(line);
                                    continue;
                                }
                                current.set(index, line);
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        currEdited = true;
                    } else if (value != null) {
                        current = value;
                        currEdited = true;
                    }
                    if (start != null) {
                        sidebar.setStart(start.asInt());
                        currEdited = true;
                    }
                    if (increment != null) {
                        sidebar.setIncrement(increment.asInt());
                        currEdited = true;
                    }
                    if (title != null) {
                        sidebar.setTitle(title.asString());
                    }
                    if (currEdited) {
                        sidebar.setLines(current);
                    }
                    sidebar.sendUpdate();
                }
                break;
            }
        }
    }

    private static Sidebar createSidebar(dPlayer denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        Player player = denizenPlayer.getPlayerEntity();
        Sidebar sidebar = sidebars.get(player.getUniqueId());
        if (sidebar == null) {
            sidebar = new Sidebar(player);
        }
        return sidebar;
    }

    public static Sidebar getSidebar(dPlayer denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        return sidebars.get(denizenPlayer.getPlayerEntity().getUniqueId());
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action;

        static {
            $SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action = new int[Action.values().length];
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action[Action.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action[Action.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action[Action.SET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class SidebarEvents
    implements Listener {
        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (sidebars.containsKey(uuid)) {
                sidebars.remove(uuid);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sidebar {
        private final Player player;
        private String title;
        private String[] lines;
        private int[] scores;
        private int start;
        private int increment;
        private ScoreboardObjective obj1;
        private ScoreboardObjective obj2;

        public Sidebar(Player player) {
            this.player = player;
            this.obj1 = new ScoreboardObjective(dummyScoreboard, "dummy_1", dummyCriteria);
            this.obj2 = new ScoreboardObjective(dummyScoreboard, "dummy_2", dummyCriteria);
            this.setTitle("");
            this.lines = new String[15];
            this.scores = new int[15];
            this.start = Integer.MIN_VALUE;
            this.increment = -1;
            sidebars.put(player.getUniqueId(), this);
        }

        public String getTitle() {
            return this.title;
        }

        public List<String> getLines() {
            return new ArrayList<String>(Arrays.asList(this.lines));
        }

        public int[] getScores() {
            return this.scores;
        }

        public int getStart() {
            return this.start;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setTitle(String title) {
            if (title.length() > 32) {
                title = title.substring(0, 32);
            }
            if (this.title == null || !this.title.equals(title)) {
                this.title = title;
                this.obj1.setDisplayName(title);
                this.obj2.setDisplayName(title);
            }
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }

        public void setLines(List<String> lines) {
            lines.removeAll(Collections.singleton(null));
            this.lines = new String[15];
            this.scores = new int[15];
            int score = this.start;
            if (score == Integer.MIN_VALUE) {
                score = lines.size();
            }
            int i = 0;
            while (i < lines.size() && i < this.lines.length) {
                String line = lines.get(i);
                if (line.length() > 40) {
                    line = line.substring(0, 40);
                }
                this.lines[i] = line;
                this.scores[i] = score;
                ++i;
                score += this.increment;
            }
        }

        public void sendUpdate() {
            String line;
            PacketHelper.sendPacket(this.player, (Packet)new PacketPlayOutScoreboardObjective(this.obj1, 0));
            for (int i = 0; i < this.lines.length && (line = this.lines[i]) != null; ++i) {
                ScoreboardScore score = new ScoreboardScore(dummyScoreboard, this.obj1, line);
                score.setScore(this.scores[i]);
                PacketHelper.sendPacket(this.player, (Packet)new PacketPlayOutScoreboardScore(score));
            }
            PacketHelper.sendPacket(this.player, (Packet)new PacketPlayOutScoreboardDisplayObjective(1, this.obj1));
            PacketHelper.sendPacket(this.player, (Packet)new PacketPlayOutScoreboardObjective(this.obj2, 1));
            ScoreboardObjective temp = this.obj2;
            this.obj2 = this.obj1;
            this.obj1 = temp;
        }

        public void remove() {
            PacketHelper.sendPacket(this.player, (Packet)new PacketPlayOutScoreboardObjective(this.obj2, 1));
            sidebars.remove(this.player.getUniqueId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

