/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptHelper;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.text.StringHolder;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class InventoryScriptContainer
extends ScriptContainer {
    public InventoryScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        InventoryScriptHelper.inventory_scripts.put(this.getName(), this);
    }

    public InventoryType getInventoryType() {
        String typeStr = this.getString("inventory", "CHEST");
        try {
            return InventoryType.valueOf((String)typeStr.toUpperCase());
        }
        catch (Exception e) {
            return InventoryType.CHEST;
        }
    }

    public dInventory getInventoryFrom(dPlayer player, dNPC npc) {
        dInventory inventory;
        block32: {
            inventory = null;
            BukkitTagContext context = new BukkitTagContext(player, npc, false, null, this.shouldDebug(), new dScript(this));
            try {
                dList list;
                List<ScriptEntry> entries;
                if (this.contains("INVENTORY")) {
                    if (InventoryType.valueOf((String)this.getString("INVENTORY").toUpperCase()) != null) {
                        inventory = new dInventory(InventoryType.valueOf((String)this.getString("INVENTORY").toUpperCase()));
                        inventory.setIdentifiers("script", this.getName());
                        if (this.contains("TITLE")) {
                            inventory.setTitle(TagManager.tag(this.getString("TITLE"), context));
                        }
                    } else {
                        dB.echoError("Invalid inventory type specified. Assuming \"CHEST\"");
                    }
                }
                int size = 0;
                if (this.contains("SIZE")) {
                    if (inventory != null && !this.getInventoryType().name().equalsIgnoreCase("CHEST")) {
                        dB.echoError("You can only set the size of chest inventories!");
                    } else {
                        size = aH.getIntegerFrom(TagManager.tag(this.getString("SIZE"), context));
                        if (size == 0) {
                            dB.echoError("Inventory size can't be 0. Assuming default of inventory type...");
                        }
                        if (size % 9 != 0) {
                            size = (int)Math.ceil(size / 9) * 9;
                            dB.echoError("Inventory size must be a multiple of 9! Rounding up to " + size + "...");
                        }
                        if (size < 0) {
                            dB.echoError("Inventory size must be a positive number! Inverting to " + (size *= -1) + "...");
                        }
                        inventory = new dInventory(size, this.contains("TITLE") ? TagManager.tag(this.getString("TITLE"), context) : "Chest");
                        inventory.setIdentifiers("script", this.getName());
                    }
                }
                if (size == 0) {
                    size = this.getInventoryType().getDefaultSize();
                }
                boolean[] filledSlots = new boolean[size];
                if (this.contains("SLOTS")) {
                    ItemStack[] finalItems = new ItemStack[size];
                    int itemsAdded = 0;
                    for (String items : this.getStringList("SLOTS")) {
                        String[] itemsInLine;
                        if ((items = TagManager.tag(items, context).trim()).isEmpty()) continue;
                        if (!items.startsWith("[") || !items.endsWith("]")) {
                            dB.echoError("Inventory script \"" + this.getName() + "\" has an invalid slots line: [" + items + "]... Ignoring it");
                            continue;
                        }
                        for (String item : itemsInLine = items.substring(1, items.length() - 1).split("\\[?\\]?\\s+\\[", -1)) {
                            if (this.contains("DEFINITIONS." + item)) {
                                dItem def = dItem.valueOf(TagManager.tag(this.getString("DEFINITIONS." + item), context), player, npc);
                                if (def == null) {
                                    dB.echoError("Invalid definition '" + item + "' in inventory script '" + this.getName() + "'" + "... Ignoring it and assuming \"AIR\"");
                                    finalItems[itemsAdded] = new ItemStack(Material.AIR);
                                } else {
                                    finalItems[itemsAdded] = def.getItemStack();
                                }
                            } else if (dItem.matches(item)) {
                                finalItems[itemsAdded] = dItem.valueOf(item, player, npc).getItemStack();
                            } else {
                                finalItems[itemsAdded] = new ItemStack(Material.AIR);
                                if (!item.isEmpty()) {
                                    dB.echoError("Inventory script \"" + this.getName() + "\" has an invalid slot item: [" + item + "]... Ignoring it and assuming \"AIR\"");
                                }
                            }
                            filledSlots[itemsAdded] = !item.isEmpty();
                            ++itemsAdded;
                        }
                    }
                    if (inventory == null) {
                        size = finalItems.length % 9 == 0 ? finalItems.length : Math.round(finalItems.length / 9) * 9;
                        inventory = new dInventory(size == 0 ? 9 : size, this.contains("TITLE") ? TagManager.tag(this.getString("TITLE"), context) : "Chest");
                    }
                    inventory.setContents(finalItems);
                }
                if (!this.contains("PROCEDURAL ITEMS")) break block32;
                if (inventory == null) {
                    size = InventoryType.CHEST.getDefaultSize();
                    inventory = new dInventory(size, this.contains("TITLE") ? TagManager.tag(this.getString("TITLE"), context) : "Chest");
                }
                if ((entries = this.getEntries(new BukkitScriptEntryData(player, npc), "PROCEDURAL ITEMS")).isEmpty()) break block32;
                long id = DetermineCommand.getNewId();
                ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                InstantQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId("INV_SCRIPT_ITEM_PROC"));
                queue.addEntries(entries);
                queue.setReqId(id);
                if (this.contains("DEFINITIONS")) {
                    YamlConfiguration section = this.getConfigurationSection("DEFINITIONS");
                    for (StringHolder string : section.getKeys(false)) {
                        String definition = string.str;
                        queue.addDefinition(definition, section.getString(definition));
                    }
                }
                queue.start();
                if (!DetermineCommand.hasOutcome(id) || (list = dList.valueOf(DetermineCommand.getOutcome(id).get(0))) == null) break block32;
                int x = 0;
                for (dItem item : list.filter(dItem.class)) {
                    while (x < filledSlots.length && filledSlots[x]) {
                        ++x;
                    }
                    if (x != filledSlots.length - 1 || !filledSlots[x]) {
                        inventory.setSlots(x, item.getItemStack());
                        filledSlots[x] = true;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                dB.echoError("Woah! An exception has been called with this inventory script!");
                dB.echoError(e);
                inventory = null;
            }
        }
        if (inventory != null) {
            InventoryScriptHelper.tempInventoryScripts.put(inventory.getInventory(), this.getName());
        }
        return inventory;
    }
}

