/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoneyRequirement
extends AbstractRequirement {
    @Override
    public boolean check(RequirementsContext context, List<String> args) throws RequirementCheckException {
        boolean outcome = true;
        if (Depends.economy != null) {
            double quantity = 0.0;
            for (String arg : args) {
                if (aH.matchesQuantity(arg) || aH.matchesInteger(arg) || aH.matchesDouble(arg)) {
                    quantity = aH.getDoubleFrom(arg);
                    dB.echoDebug((Debuggable)context.getScriptContainer(), "...quantity set to: " + quantity);
                    continue;
                }
                throw new RequirementCheckException("Unknown argument '" + arg + "'!");
            }
            double balance = Depends.economy.getBalance(context.getPlayer().getName());
            dB.echoDebug((Debuggable)context.getScriptContainer(), "...player balance: " + balance);
            outcome = balance >= quantity;
        } else {
            dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
        }
        return outcome;
    }
}

