/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.blocks;

import java.util.List;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.minecraft.server.v1_9_R1.BlockPosition;
import net.minecraft.server.v1_9_R1.NBTTagCompound;
import net.minecraft.server.v1_9_R1.TileEntity;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_9_R1.CraftWorld;

public class BlockData {
    public Material material;
    public int data;
    NBTTagCompound ctag = null;

    public BlockData() {
    }

    public BlockData(short mat, byte dat) {
        this.material = Material.getMaterial((int)mat);
        this.data = dat;
    }

    public BlockData(Block block) {
        this.material = block.getType();
        this.data = block.getData();
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            this.ctag = new NBTTagCompound();
            te.save(this.ctag);
        }
    }

    public void setBlock(Block block) {
        block.setTypeIdAndData(this.material.getId(), (byte)this.data, false);
        if (this.ctag != null) {
            this.ctag.setInt("x", block.getX());
            this.ctag.setInt("y", block.getY());
            this.ctag.setInt("z", block.getZ());
            BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
            TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
            te.a(this.ctag);
        }
    }

    public String toCompressedFormat() {
        return "{" + this.material.getId() + ":" + this.data + "}";
    }

    public static BlockData fromCompressedString(String str) {
        BlockData data = new BlockData();
        String inner = str.substring(1, str.length() - 1);
        List<String> datas = CoreUtilities.split(inner, ':');
        data.material = Material.getMaterial((int)Integer.parseInt(datas.get(0)));
        data.data = Integer.parseInt(datas.get(1));
        if (data.material == null) {
            throw new RuntimeException("Null material: " + datas.get(0));
        }
        return data;
    }

    public NBTTagCompound getNBTTag() {
        return this.ctag;
    }

    public void setNBTTag(NBTTagCompound tag) {
        this.ctag = tag;
    }
}

