/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import java.util.ArrayList;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.entity.DenizenCustomEntity;
import net.aufdemrand.denizen.utilities.entity.EntityItemProjectile;
import net.aufdemrand.denizen.utilities.entity.ItemProjectile;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.minecraft.server.v1_9_R1.EntityItem;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_9_R1.CraftServer;
import org.bukkit.craftbukkit.v1_9_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftItemProjectile
extends CraftItem
implements DenizenCustomEntity,
ItemProjectile {
    private boolean doesBounce;

    public CraftItemProjectile(CraftServer server, EntityItemProjectile entity) {
        super(server, (EntityItem)entity);
    }

    @DenizenCustomEntity.CreateEntity
    public static ItemProjectile createItemProjectile(Location location, ArrayList<Mechanism> mechanisms) {
        CraftWorld world = (CraftWorld)location.getWorld();
        ItemStack itemStack = new ItemStack(Material.STONE);
        for (Mechanism mechanism : mechanisms) {
            if (!mechanism.matches("item") || !mechanism.requireObject(dItem.class)) continue;
            itemStack = mechanism.getValue().asType(dItem.class).getItemStack();
            break;
        }
        EntityItemProjectile entity = new EntityItemProjectile(world, location, itemStack);
        return (ItemProjectile)entity.getBukkitEntity();
    }

    public EntityItemProjectile getHandle() {
        return (EntityItemProjectile)super.getHandle();
    }

    @Override
    public String getEntityTypeName() {
        return "ITEM_PROJECTILE";
    }

    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            this.getHandle().shooter = ((CraftLivingEntity)shooter).getHandle();
            if (shooter instanceof CraftHumanEntity) {
                this.getHandle().shooterName = ((CraftHumanEntity)shooter).getName();
            }
        } else {
            this.getHandle().shooter = null;
            this.getHandle().shooterName = null;
        }
        this.getHandle().projectileSource = shooter;
    }

    public boolean doesBounce() {
        return this.doesBounce;
    }

    public void setBounce(boolean doesBounce) {
        this.doesBounce = doesBounce;
    }

    public void _INVALID_setShooter(LivingEntity livingEntity) {
    }

    public LivingEntity _INVALID_getShooter() {
        return null;
    }
}

