/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.jnbt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.utilities.jnbt.ByteArrayTag;
import net.aufdemrand.denizen.utilities.jnbt.ByteTag;
import net.aufdemrand.denizen.utilities.jnbt.CompoundTagBuilder;
import net.aufdemrand.denizen.utilities.jnbt.DoubleTag;
import net.aufdemrand.denizen.utilities.jnbt.EndTag;
import net.aufdemrand.denizen.utilities.jnbt.FloatTag;
import net.aufdemrand.denizen.utilities.jnbt.IntArrayTag;
import net.aufdemrand.denizen.utilities.jnbt.IntTag;
import net.aufdemrand.denizen.utilities.jnbt.ListTag;
import net.aufdemrand.denizen.utilities.jnbt.ListTagBuilder;
import net.aufdemrand.denizen.utilities.jnbt.LongTag;
import net.aufdemrand.denizen.utilities.jnbt.ShortTag;
import net.aufdemrand.denizen.utilities.jnbt.StringTag;
import net.aufdemrand.denizen.utilities.jnbt.Tag;
import net.minecraft.server.v1_9_R1.NBTBase;
import net.minecraft.server.v1_9_R1.NBTTagByte;
import net.minecraft.server.v1_9_R1.NBTTagByteArray;
import net.minecraft.server.v1_9_R1.NBTTagCompound;
import net.minecraft.server.v1_9_R1.NBTTagDouble;
import net.minecraft.server.v1_9_R1.NBTTagEnd;
import net.minecraft.server.v1_9_R1.NBTTagFloat;
import net.minecraft.server.v1_9_R1.NBTTagInt;
import net.minecraft.server.v1_9_R1.NBTTagIntArray;
import net.minecraft.server.v1_9_R1.NBTTagList;
import net.minecraft.server.v1_9_R1.NBTTagLong;
import net.minecraft.server.v1_9_R1.NBTTagShort;
import net.minecraft.server.v1_9_R1.NBTTagString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundTag
extends Tag {
    private final Map<String, Tag> value;

    public NBTTagCompound toNMSTag() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            if (entry.getValue() instanceof IntTag) {
                tag.setInt(entry.getKey(), ((IntTag)entry.getValue()).getValue().intValue());
                continue;
            }
            if (entry.getValue() instanceof ByteTag) {
                tag.setByte(entry.getKey(), ((ByteTag)entry.getValue()).getValue().byteValue());
                continue;
            }
            if (entry.getValue() instanceof ByteArrayTag) {
                tag.setByteArray(entry.getKey(), ((ByteArrayTag)entry.getValue()).getValue());
                continue;
            }
            if (entry.getValue() instanceof CompoundTag) {
                tag.set(entry.getKey(), (NBTBase)((CompoundTag)entry.getValue()).toNMSTag());
                continue;
            }
            if (entry.getValue() instanceof DoubleTag) {
                tag.setDouble(entry.getKey(), ((DoubleTag)entry.getValue()).getValue().doubleValue());
                continue;
            }
            if (entry.getValue() instanceof FloatTag) {
                tag.setFloat(entry.getKey(), ((FloatTag)entry.getValue()).getValue().floatValue());
                continue;
            }
            if (entry.getValue() instanceof IntArrayTag) {
                tag.setIntArray(entry.getKey(), ((IntArrayTag)entry.getValue()).getValue());
                continue;
            }
            if (entry.getValue() instanceof ListTag) {
                NBTTagList list = new NBTTagList();
                Object tags = ((ListTag)entry.getValue()).getValue();
                Iterator i$ = tags.iterator();
                while (i$.hasNext()) {
                    Tag btag = (Tag)i$.next();
                    HashMap<String, Tag> btags = new HashMap<String, Tag>();
                    btags.put("test", btag);
                    CompoundTag comp = new CompoundTag(btags);
                    list.add(comp.toNMSTag().get("test"));
                }
                tag.set(entry.getKey(), (NBTBase)list);
                continue;
            }
            if (entry.getValue() instanceof LongTag) {
                tag.setLong(entry.getKey(), ((LongTag)entry.getValue()).getValue().longValue());
                continue;
            }
            if (entry.getValue() instanceof ShortTag) {
                tag.setShort(entry.getKey(), ((ShortTag)entry.getValue()).getValue().shortValue());
                continue;
            }
            if (!(entry.getValue() instanceof StringTag)) continue;
            tag.setString(entry.getKey(), ((StringTag)entry.getValue()).getValue());
        }
        return tag;
    }

    public static CompoundTag fromNMSTag(NBTTagCompound tag) {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        for (String key : tag.c()) {
            NBTTagList list;
            NBTBase base = tag.get(key);
            if (base instanceof NBTTagInt) {
                tags.put(key, new IntTag(((NBTTagInt)base).d()));
                continue;
            }
            if (base instanceof NBTTagByte) {
                tags.put(key, new ByteTag(((NBTTagByte)base).f()));
                continue;
            }
            if (base instanceof NBTTagFloat) {
                tags.put(key, new FloatTag(((NBTTagFloat)base).h()));
                continue;
            }
            if (base instanceof NBTTagDouble) {
                tags.put(key, new DoubleTag(((NBTTagDouble)base).g()));
                continue;
            }
            if (base instanceof NBTTagByteArray) {
                tags.put(key, new ByteArrayTag(((NBTTagByteArray)base).c()));
                continue;
            }
            if (base instanceof NBTTagIntArray) {
                tags.put(key, new IntArrayTag(((NBTTagIntArray)base).c()));
                continue;
            }
            if (base instanceof NBTTagCompound) {
                tags.put(key, CompoundTag.fromNMSTag((NBTTagCompound)base));
                continue;
            }
            if (base instanceof NBTTagEnd) {
                tags.put(key, new EndTag());
                continue;
            }
            if (base instanceof NBTTagLong) {
                tags.put(key, new LongTag(((NBTTagLong)base).c()));
                continue;
            }
            if (base instanceof NBTTagShort) {
                tags.put(key, new ShortTag(((NBTTagShort)base).e()));
                continue;
            }
            if (base instanceof NBTTagString) {
                tags.put(key, new StringTag(((NBTTagString)base).a_()));
                continue;
            }
            if (!(base instanceof NBTTagList) || (list = (NBTTagList)base).size() <= 0) continue;
            NBTBase nbase = list.h(0);
            NBTTagCompound comp = new NBTTagCompound();
            comp.set("test", nbase);
            ListTagBuilder ltb = new ListTagBuilder(((Tag)CompoundTag.fromNMSTag(comp).getValue().get("test")).getClass());
            for (int i = 0; i < list.size(); ++i) {
                NBTBase nbase2 = list.h(i);
                NBTTagCompound comp2 = new NBTTagCompound();
                comp2.set("test", nbase2);
                ltb.add((Tag)CompoundTag.fromNMSTag(comp2).getValue().get("test"));
            }
            tags.put(key, ltb.build());
        }
        return new CompoundTag(tags);
    }

    public CompoundTag(Map<String, Tag> value) {
        this.value = Collections.unmodifiableMap(value);
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    @Override
    public Map<String, Tag> getValue() {
        return this.value;
    }

    public CompoundTag setValue(Map<String, Tag> value) {
        return new CompoundTag(value);
    }

    public CompoundTagBuilder createBuilder() {
        return new CompoundTagBuilder(new HashMap<String, Tag>(this.value));
    }

    public byte[] getByteArray(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ByteArrayTag) {
            return ((ByteArrayTag)tag).getValue();
        }
        return new byte[0];
    }

    public byte getByte(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getValue();
        }
        return 0;
    }

    public double getDouble(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).getValue();
        }
        return 0.0;
    }

    public double asDouble(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getValue().byteValue();
        }
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).getValue().shortValue();
        }
        if (tag instanceof IntTag) {
            return ((IntTag)tag).getValue().intValue();
        }
        if (tag instanceof LongTag) {
            return ((LongTag)tag).getValue().longValue();
        }
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).getValue().floatValue();
        }
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).getValue();
        }
        return 0.0;
    }

    public float getFloat(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).getValue().floatValue();
        }
        return 0.0f;
    }

    public int[] getIntArray(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof IntArrayTag) {
            return ((IntArrayTag)tag).getValue();
        }
        return new int[0];
    }

    public int getInt(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof IntTag) {
            return ((IntTag)tag).getValue();
        }
        return 0;
    }

    public int asInt(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getValue().byteValue();
        }
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).getValue().shortValue();
        }
        if (tag instanceof IntTag) {
            return ((IntTag)tag).getValue();
        }
        if (tag instanceof LongTag) {
            return ((LongTag)tag).getValue().intValue();
        }
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).getValue().intValue();
        }
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).getValue().intValue();
        }
        return 0;
    }

    public List<Tag> getList(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ListTag) {
            return ((ListTag)tag).getValue();
        }
        return Collections.emptyList();
    }

    public ListTag getListTag(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ListTag) {
            return (ListTag)tag;
        }
        return new ListTag(StringTag.class, Collections.emptyList());
    }

    public <T extends Tag> List<T> getList(String key, Class<T> listType) {
        Tag tag = this.value.get(key);
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            if (listTag.getType().equals(listType)) {
                return listTag.getValue();
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public long getLong(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof LongTag) {
            return ((LongTag)tag).getValue();
        }
        return 0L;
    }

    public long asLong(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getValue().byteValue();
        }
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).getValue().shortValue();
        }
        if (tag instanceof IntTag) {
            return ((IntTag)tag).getValue().intValue();
        }
        if (tag instanceof LongTag) {
            return ((LongTag)tag).getValue();
        }
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).getValue().longValue();
        }
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).getValue().longValue();
        }
        return 0L;
    }

    public short getShort(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).getValue();
        }
        return 0;
    }

    public String getString(String key) {
        Tag tag = this.value.get(key);
        if (tag instanceof StringTag) {
            return ((StringTag)tag).getValue();
        }
        return "";
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_Compound").append(": ").append(this.value.size()).append(" entries\r\n{\r\n");
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            bldr.append("   ").append(entry.getValue().toString().replaceAll("\r\n", "\r\n   ")).append("\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }
}

