/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets.intercept;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import javax.crypto.SecretKey;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.intercept.DenizenPacketListener;
import net.aufdemrand.denizen.utilities.packets.intercept.PacketOutHandler;
import net.minecraft.server.v1_9_R1.EntityPlayer;
import net.minecraft.server.v1_9_R1.EnumProtocol;
import net.minecraft.server.v1_9_R1.EnumProtocolDirection;
import net.minecraft.server.v1_9_R1.IChatBaseComponent;
import net.minecraft.server.v1_9_R1.NetworkManager;
import net.minecraft.server.v1_9_R1.Packet;
import net.minecraft.server.v1_9_R1.PacketListener;
import net.minecraft.server.v1_9_R1.PlayerConnection;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenNetworkManager
extends NetworkManager {
    private final NetworkManager oldManager;
    private final DenizenPacketListener packetListener;
    private final EntityPlayer player;
    private static final Field protocolDirectionField;
    private static final Field networkManagerField;

    public DenizenNetworkManager(EntityPlayer entityPlayer, NetworkManager oldManager) {
        super(DenizenNetworkManager.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.channel = oldManager.channel;
        this.packetListener = new DenizenPacketListener(this, entityPlayer);
        oldManager.setPacketListener((PacketListener)this.packetListener);
        this.player = this.packetListener.player;
    }

    public static void setNetworkManager(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.playerConnection;
        DenizenNetworkManager.setNetworkManager(playerConnection, new DenizenNetworkManager(entityPlayer, playerConnection.networkManager));
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void setProtocol(EnumProtocol enumprotocol) {
        this.oldManager.setProtocol(enumprotocol);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) throws Exception {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet packet) throws Exception {
        if (this.oldManager.channel.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPacketListener(PacketListener packetlistener) {
        this.oldManager.setPacketListener(packetlistener);
    }

    public void sendPacket(Packet packet) {
        if (!PacketOutHandler.sendPacket(this.player, packet)) {
            this.oldManager.sendPacket(packet);
        }
    }

    public void sendPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener, GenericFutureListener<? extends Future<? super Void>> ... agenericfuturelistener) {
        this.oldManager.sendPacket(packet, genericfuturelistener, agenericfuturelistener);
    }

    public void a() {
        this.oldManager.a();
    }

    public SocketAddress getSocketAddress() {
        return this.oldManager.getSocketAddress();
    }

    public void close(IChatBaseComponent ichatbasecomponent) {
        this.oldManager.close(ichatbasecomponent);
    }

    public boolean isLocal() {
        return this.oldManager.isLocal();
    }

    public void a(SecretKey secretkey) {
        this.oldManager.a(secretkey);
    }

    public boolean isConnected() {
        return this.oldManager.isConnected();
    }

    public boolean h() {
        return this.oldManager.h();
    }

    public PacketListener i() {
        return this.oldManager.i();
    }

    public IChatBaseComponent j() {
        return this.oldManager.j();
    }

    public void stopReading() {
        this.oldManager.stopReading();
    }

    public void setCompressionLevel(int i) {
        this.oldManager.setCompressionLevel(i);
    }

    public void handleDisconnection() {
        this.oldManager.handleDisconnection();
    }

    protected void channelRead0(ChannelHandlerContext channelhandlercontext, Packet object) throws Exception {
        this.a(channelhandlercontext, object);
    }

    public SocketAddress getRawAddress() {
        return this.oldManager.getRawAddress();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            networkManagerField.set(playerConnection, networkManager);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    static {
        Field directionField = null;
        Field managerField = null;
        try {
            directionField = NetworkManager.class.getDeclaredField("h");
            directionField.setAccessible(true);
            managerField = PlayerConnection.class.getDeclaredField("networkManager");
            managerField.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        protocolDirectionField = directionField;
        networkManagerField = managerField;
    }
}

