/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events.core;

import java.util.Date;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class SystemTimeScriptEvent
extends ScriptEvent {
    public static SystemTimeScriptEvent instance;
    public Element hour;
    public ScriptEntryData data = null;
    public Element minute;
    boolean enab = false;
    int lH = 0;
    int lM = 0;

    public SystemTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer script, String event) {
        return event.startsWith("system time");
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public boolean matches(ScriptContainer script, String event) {
        String time = CoreUtilities.getXthArg(2, event);
        return time.equals("minutely") || time.equals(this.hour.asString() + ":" + this.minute.asString()) || this.minute.asString().equals("00") && time.equals("hourly");
    }

    @Override
    public String getName() {
        return "SystemTime";
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("hour")) {
            return this.hour;
        }
        if (name.equals("minute")) {
            return this.minute;
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enab = true;
    }

    @Override
    public void destroy() {
        this.enab = false;
    }

    public void checkTime() {
        if (!this.enab) {
            return;
        }
        Date date = new Date();
        int h = date.getHours();
        int m = date.getMinutes();
        if (this.lH == h && this.lM == m) {
            return;
        }
        this.lH = h;
        this.lM = m;
        this.hour = h < 10 ? new Element("0" + h) : new Element(h);
        this.minute = m < 10 ? new Element("0" + m) : new Element(m);
        this.data = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.fire();
    }
}

