/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import java.util.List;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.core.ProcedureScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ProcedureScriptTags {
    public ProcedureScriptTags() {
        TagManager.registerTagEvents(this);
    }

    @TagManager.TagEvents
    public void procedureTag(ReplaceableTagEvent event) {
        if (!event.matches("proc", "pr")) {
            return;
        }
        Attribute attr = event.getAttributes();
        int attribs = 1;
        dScript script = null;
        String path = null;
        if (event.hasNameContext()) {
            if (event.getNameContext().indexOf(46) > 0) {
                String[] split = event.getNameContext().split("\\.", 2);
                path = split[1];
                script = dScript.valueOf(split[0]);
            } else {
                script = dScript.valueOf(event.getNameContext());
            }
        } else if (event.getValue() != null) {
            script = dScript.valueOf(event.getValue());
        } else {
            dB.echoError("Invalid procedure script tag '" + event.getValue() + "'!");
            return;
        }
        if (script == null) {
            dB.echoError("Missing script for procedure script tag '" + event.getValue() + "'!");
            return;
        }
        if (!(script.getContainer() instanceof ProcedureScriptContainer)) {
            dB.echoError("Chosen script is not a procedure script!");
            return;
        }
        List<ScriptEntry> entries = path != null ? script.getContainer().getEntries(event.getContext().getScriptEntryData(), path) : script.getContainer().getBaseEntries(event.getContext().getScriptEntryData());
        if (entries.isEmpty()) {
            return;
        }
        long id = DetermineCommand.getNewId();
        ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
        InstantQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(script.getContainer().getName()));
        queue.addEntries(entries);
        queue.setReqId(id);
        if (event.hasType() && event.getType().equalsIgnoreCase("context") && event.hasTypeContext()) {
            attribs = 2;
            int x = 1;
            dList definitions = new dList(event.getTypeContext());
            String[] definition_names = null;
            try {
                definition_names = script.getContainer().getString("definitions").split("\\|");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String definition : definitions) {
                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                queue.addDefinition(name, definition);
                dB.echoDebug((Debuggable)(event.getScriptEntry() == null ? (event.getScript() == null ? null : event.getScript().getContainer()) : event.getScriptEntry()), "Adding definition %" + name + "% as " + definition);
                ++x;
            }
        }
        queue.start();
        if (DetermineCommand.hasOutcome(id)) {
            event.setReplaced(ObjectFetcher.pickObjectFor(DetermineCommand.getOutcome(id).get(0)).getAttribute(attr.fulfill(attribs)));
        }
    }
}

