/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.Collection;
import java.util.List;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityPotionEffects
implements Property {
    dEntity entity;

    public static boolean describes(dObject object) {
        return object instanceof dEntity && ((dEntity)object).isLivingEntity();
    }

    public static EntityPotionEffects getFrom(dObject object) {
        if (!EntityPotionEffects.describes(object)) {
            return null;
        }
        return new EntityPotionEffects((dEntity)object);
    }

    private EntityPotionEffects(dEntity entity) {
        this.entity = entity;
    }

    public String getPropertyString() {
        Collection effects = this.entity.getLivingEntity().getActivePotionEffects();
        if (effects.isEmpty()) {
            return null;
        }
        dList returnable = new dList();
        for (PotionEffect effect : effects) {
            returnable.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration());
        }
        return returnable.identify().substring(3);
    }

    public String getPropertyId() {
        return "potion_effects";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("list_effects")) {
            dList effects = new dList();
            for (PotionEffect effect : this.entity.getLivingEntity().getActivePotionEffects()) {
                effects.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration());
            }
            return effects.getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            dList effects = dList.valueOf(mechanism.getValue().asString());
            for (String effect : effects) {
                List<String> split = CoreUtilities.split(effect, ',');
                if (split.size() != 3) continue;
                PotionEffectType effectType = PotionEffectType.getByName((String)split.get(0));
                if (Integer.valueOf(split.get(1)) == null || Integer.valueOf(split.get(2)) == null || effectType == null) continue;
                this.entity.getLivingEntity().addPotionEffect(new PotionEffect(effectType, Integer.valueOf(split.get(2)).intValue(), Integer.valueOf(split.get(1)).intValue()));
            }
        }
    }
}

