/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class BurnCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("entities", ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity()) : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity()) : null);
        scriptEntry.defaultObject("duration", Duration.valueOf("5s"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dB.report(scriptEntry, this.getName(), duration.debug() + aH.debugObj("entities", entities.toString()));
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            entity.getBukkitEntity().setFireTicks(duration.getTicksAsInt());
        }
    }
}

