/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;

public class EquipCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        HashMap<String, dItem> equipment = new HashMap<String, dItem>();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("head", "helmet")) {
                equipment.put("head", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("chest", "chestplate")) {
                equipment.put("chest", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("legs", "leggings")) {
                equipment.put("legs", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("boots", "feet")) {
                equipment.put("boots", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("saddle")) {
                equipment.put("saddle", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("horse_armor", "horse_armour")) {
                equipment.put("horse_armor", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("offhand")) {
                equipment.put("offhand", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class)) {
                equipment.put("hand", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matches("player") && ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer()) {
                scriptEntry.addObject("entities", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (equipment.isEmpty()) {
            throw new InvalidArgumentsException("Must specify equipment!");
        }
        scriptEntry.addObject("equipment", equipment);
        scriptEntry.defaultObject("entities", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity()) : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity()) : null);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Map equipment = (Map)scriptEntry.getObject("equipment");
        List entities = (List)scriptEntry.getObject("entities");
        dB.report(scriptEntry, this.getName(), aH.debugObj("entities", entities.toString()) + aH.debugObj("equipment", equipment.toString()));
        for (dEntity entity : entities) {
            if (entity.isGeneric()) {
                dB.echoError(scriptEntry.getResidingQueue(), "Cannot equip generic entity " + entity.identify() + "!");
                continue;
            }
            if (entity.isCitizensNPC()) {
                dNPC npc = entity.getDenizenNPC();
                if (npc == null) continue;
                Equipment trait = npc.getEquipmentTrait();
                if (equipment.get("hand") != null) {
                    trait.set(0, ((dItem)equipment.get("hand")).getItemStack());
                }
                if (equipment.get("head") != null) {
                    trait.set(1, ((dItem)equipment.get("head")).getItemStack());
                }
                if (equipment.get("chest") != null) {
                    trait.set(2, ((dItem)equipment.get("chest")).getItemStack());
                }
                if (equipment.get("legs") != null) {
                    trait.set(3, ((dItem)equipment.get("legs")).getItemStack());
                }
                if (equipment.get("boots") != null) {
                    trait.set(4, ((dItem)equipment.get("boots")).getItemStack());
                }
                if (equipment.get("offhand") == null) continue;
                trait.set(5, ((dItem)equipment.get("offhand")).getItemStack());
                continue;
            }
            LivingEntity livingEntity = entity.getLivingEntity();
            if (livingEntity == null) continue;
            if (livingEntity.getType() == EntityType.HORSE) {
                if (equipment.get("saddle") != null) {
                    ((Horse)livingEntity).getInventory().setSaddle(((dItem)equipment.get("saddle")).getItemStack());
                }
                if (equipment.get("horse_armor") == null) continue;
                ((Horse)livingEntity).getInventory().setArmor(((dItem)equipment.get("horse_armor")).getItemStack());
                continue;
            }
            if (livingEntity.getType() == EntityType.PIG) {
                if (equipment.get("saddle") == null) continue;
                dItem saddle = (dItem)equipment.get("saddle");
                if (saddle.getItemStack().getType() == Material.SADDLE) {
                    ((Pig)livingEntity).setSaddle(true);
                    continue;
                }
                ((Pig)livingEntity).setSaddle(false);
                continue;
            }
            if (equipment.get("hand") != null) {
                livingEntity.getEquipment().setItemInMainHand(((dItem)equipment.get("hand")).getItemStack());
            }
            if (equipment.get("head") != null) {
                livingEntity.getEquipment().setHelmet(((dItem)equipment.get("head")).getItemStack());
            }
            if (equipment.get("chest") != null) {
                livingEntity.getEquipment().setChestplate(((dItem)equipment.get("chest")).getItemStack());
            }
            if (equipment.get("legs") != null) {
                livingEntity.getEquipment().setLeggings(((dItem)equipment.get("legs")).getItemStack());
            }
            if (equipment.get("boots") != null) {
                livingEntity.getEquipment().setBoots(((dItem)equipment.get("boots")).getItemStack());
            }
            if (equipment.get("offhand") == null) continue;
            livingEntity.getEquipment().setItemInOffHand(((dItem)equipment.get("offhand")).getItemStack());
        }
    }
}

