/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.blocks.SafeBlock;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PushCommand
extends AbstractCommand
implements Holdable {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "shooter", "s")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("originEntity", arg.asType(dEntity.class));
                    continue;
                }
                if (arg.matchesArgumentType(dLocation.class)) {
                    scriptEntry.addObject("originLocation", arg.asType(dLocation.class));
                    continue;
                }
                dB.echoError("Ignoring unrecognized argument: " + arg.raw_value);
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("destination", "d")) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration", "d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("speed", "s")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && (arg.matchesArgumentType(dScript.class) || arg.matchesPrefix("script"))) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("force_along") && arg.matches("force_along")) {
                scriptEntry.addObject("force_along", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("no_rotate") && arg.matches("no_rotate")) {
                scriptEntry.addObject("no_rotate", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("precision") && arg.matchesPrefix("precision")) {
                scriptEntry.addObject("precision", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("no_damage") && arg.matches("no_damage")) {
                scriptEntry.addObject("no_damage", new Element(true));
                continue;
            }
            if (arg.matchesPrefix("def", "define", "context")) {
                scriptEntry.addObject("definitions", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("originLocation")) {
            scriptEntry.defaultObject("originEntity", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity() : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity() : null);
        }
        scriptEntry.defaultObject("speed", new Element(1.5));
        scriptEntry.defaultObject("duration", new Duration(20));
        scriptEntry.defaultObject("force_along", new Element(false));
        scriptEntry.defaultObject("precision", new Element(2));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("originEntity") && !scriptEntry.hasObject("originLocation")) {
            throw new InvalidArgumentsException("Must specify an origin location!");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation destination;
        boolean no_damage;
        dEntity originEntity = (dEntity)scriptEntry.getObject("originEntity");
        dLocation originLocation = scriptEntry.hasObject("originLocation") ? (dLocation)scriptEntry.getObject("originLocation") : new dLocation(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0));
        boolean no_rotate = scriptEntry.hasObject("no_rotate") && scriptEntry.getElement("no_rotate").asBoolean();
        boolean bl = no_damage = scriptEntry.hasObject("no_damage") && scriptEntry.getElement("no_damage").asBoolean();
        dLocation dLocation2 = scriptEntry.hasObject("destination") ? (dLocation)scriptEntry.getObject("destination") : (destination = originEntity != null ? new dLocation(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection().multiply(30))) : null);
        if (destination == null) {
            dB.report(scriptEntry, this.getName(), "No destination specified!");
            scriptEntry.setFinished(true);
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        final dScript script = (dScript)scriptEntry.getObject("script");
        final dList definitions = (dList)scriptEntry.getObject("definitions");
        final double speed = scriptEntry.getElement("speed").asDouble();
        final int maxTicks = ((Duration)scriptEntry.getObject("duration")).getTicksAsInt();
        Element force_along = scriptEntry.getElement("force_along");
        Element precision = scriptEntry.getElement("precision");
        dB.report(scriptEntry, this.getName(), aH.debugObj("origin", originEntity != null ? originEntity : originLocation) + aH.debugObj("entities", entities.toString()) + aH.debugObj("destination", destination) + aH.debugObj("speed", speed) + aH.debugObj("max ticks", maxTicks) + (script != null ? script.debug() : "") + force_along.debug() + precision.debug() + (no_rotate ? aH.debugObj("no_rotate", "true") : "") + (no_damage ? aH.debugObj("no_damage", "true") : "") + (definitions != null ? definitions.debug() : ""));
        final boolean forceAlong = force_along.asBoolean();
        final dList entityList = new dList();
        for (dEntity entity : entities) {
            entity.spawnAt(originLocation);
            entityList.add(entity.toString());
            if (!no_rotate) {
                Rotation.faceLocation(entity.getBukkitEntity(), (Location)destination);
            }
            if (!entity.isProjectile() || originEntity == null) continue;
            entity.setShooter(originEntity);
        }
        scriptEntry.addObject("pushed_entities", entityList);
        Position.mount(Conversion.convertEntities(entities));
        final dEntity lastEntity = (dEntity)entities.get(entities.size() - 1);
        final Vector v2 = destination.toVector();
        final Vector Origin = originLocation.toVector();
        final int prec = precision.asInt();
        BukkitRunnable task = new BukkitRunnable(){
            int runs = 0;
            dLocation lastLocation;

            public void run() {
                if (this.runs < maxTicks && lastEntity.isValid()) {
                    Vector v1 = lastEntity.getLocation().toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize();
                    Vector newVel = v3.multiply(speed);
                    lastEntity.setVelocity(newVel);
                    if (forceAlong) {
                        Vector newDest = v2.clone().subtract(Origin).normalize().multiply(this.runs / 20).add(Origin);
                        lastEntity.teleport(new Location(lastEntity.getLocation().getWorld(), newDest.getX(), newDest.getY(), newDest.getZ(), lastEntity.getLocation().getYaw(), lastEntity.getLocation().getPitch()));
                    }
                    this.runs += prec;
                    if (Math.abs(v2.getX() - v1.getX()) < 1.5 && Math.abs(v2.getY() - v1.getY()) < 1.5 && Math.abs(v2.getZ() - v1.getZ()) < 1.5) {
                        this.runs = maxTicks;
                    }
                    if (!SafeBlock.blockIsSafe(lastEntity.getLocation().add(v3).getBlock().getType()) || !SafeBlock.blockIsSafe(lastEntity.getLocation().add(newVel).getBlock().getType())) {
                        this.runs = maxTicks;
                    }
                    if (no_damage && lastEntity.isLivingEntity()) {
                        lastEntity.getLivingEntity().setFallDistance(0.0f);
                    }
                    this.lastLocation = lastEntity.getLocation();
                } else {
                    this.cancel();
                    if (script != null) {
                        List<ScriptEntry> entries = script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
                        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(script.getContainer().getName())).addEntries(entries);
                        if (lastEntity.getLocation() != null) {
                            queue.addDefinition("location", lastEntity.getLocation().identify());
                        } else {
                            queue.addDefinition("location", this.lastLocation.identify());
                        }
                        queue.addDefinition("pushed_entities", entityList.toString());
                        queue.addDefinition("last_entity", lastEntity.identify());
                        if (definitions != null) {
                            int x = 1;
                            String[] definition_names = null;
                            try {
                                definition_names = script.getContainer().getString("definitions").split("\\|");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            for (String definition : definitions) {
                                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                                queue.addDefinition(name, definition);
                                dB.echoDebug((Debuggable)scriptEntry, "Adding definition %" + name + "% as " + definition);
                                ++x;
                            }
                        }
                        queue.start();
                    }
                    scriptEntry.setFinished(true);
                }
            }
        };
        task.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 0L, (long)prec);
    }
}

