/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.objects.properties.item.ItemSkullskin;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.minecraft.server.v1_10_R1.EntityHuman;
import net.minecraft.server.v1_10_R1.EntityPlayer;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_10_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_10_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_10_R1.PacketPlayOutRespawn;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerProfileEditor {
    private static final Map<UUID, GameProfile> fakeProfiles = new HashMap<UUID, GameProfile>();
    private static final Field playerGameProfile;
    private static final Field gameProfileId;
    private static final Field gameProfileName;
    private static final Field playerInfo_action;
    private static final Field playerInfo_data;
    private static final Field playerInfoData_gameProfile;

    public static void updatePlayerProfiles(PacketPlayOutPlayerInfo packet) {
        try {
            PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = (PacketPlayOutPlayerInfo.EnumPlayerInfoAction)playerInfo_action.get(packet);
            if (action != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
                return;
            }
            List dataList = (List)playerInfo_data.get(packet);
            for (Object data : dataList) {
                GameProfile gameProfile = (GameProfile)playerInfoData_gameProfile.get(data);
                if (!fakeProfiles.containsKey(gameProfile.getId())) continue;
                playerInfoData_gameProfile.set(data, fakeProfiles.get(gameProfile.getId()));
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static void setPlayerName(Player player, String name) {
        GameProfile gameProfile = PlayerProfileEditor.getFakeProfile(player);
        PlayerProfileEditor.setProfileName(gameProfile, name);
        PlayerProfileEditor.updatePlayer(player, false);
    }

    public static String getPlayerName(Player player) {
        return PlayerProfileEditor.getFakeProfile(player).getName();
    }

    public static void setPlayerSkin(Player player, String name) {
        GameProfile gameProfile = PlayerProfileEditor.getFakeProfile(player);
        gameProfile.getProperties().get((Object)"textures").clear();
        GameProfile skinProfile = ItemSkullskin.fillGameProfile(new GameProfile(null, name));
        for (Property texture : skinProfile.getProperties().get((Object)"textures")) {
            gameProfile.getProperties().put((Object)"textures", (Object)texture);
        }
        PlayerProfileEditor.updatePlayer(player, true);
    }

    public static void setPlayerSkinBlob(Player player, String blob) {
        GameProfile gameProfile = PlayerProfileEditor.getFakeProfile(player);
        gameProfile.getProperties().get((Object)"textures").clear();
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", blob));
        PlayerProfileEditor.updatePlayer(player, true);
    }

    public static String getPlayerSkinBlob(Player player) {
        return ((Property)PlayerProfileEditor.getFakeProfile(player).getProperties().get((Object)"textures").iterator().next()).getValue();
    }

    private static void updatePlayer(Player player, final boolean isSkinChanging) {
        final EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        final UUID uuid = player.getUniqueId();
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{entityPlayer.getId()});
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p.getUniqueId().equals(uuid)) continue;
            PacketHelper.sendPacket(p, (Packet)destroyPacket);
        }
        new BukkitRunnable(){

            public void run() {
                PacketPlayOutPlayerInfo playerInfo = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entityPlayer});
                PacketPlayOutNamedEntitySpawn spawnPacket = new PacketPlayOutNamedEntitySpawn((EntityHuman)entityPlayer);
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    PacketHelper.sendPacket(player, (Packet)playerInfo);
                    if (!player.getUniqueId().equals(uuid)) {
                        PacketHelper.sendPacket(player, (Packet)spawnPacket);
                        continue;
                    }
                    if (isSkinChanging) {
                        boolean isFlying = player.isFlying();
                        PacketHelper.sendPacket(player, (Packet)new PacketPlayOutRespawn(player.getWorld().getEnvironment().getId(), entityPlayer.getWorld().getDifficulty(), entityPlayer.getWorld().worldData.getType(), entityPlayer.playerInteractManager.getGameMode()));
                        player.teleport(player.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        player.setFlying(isFlying);
                    }
                    player.updateInventory();
                }
            }
        }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 5L);
    }

    private static GameProfile getFakeProfile(Player player) {
        UUID uuid = player.getUniqueId();
        if (fakeProfiles.containsKey(uuid)) {
            return fakeProfiles.get(uuid);
        }
        GameProfile fakeProfile = new GameProfile(player.getUniqueId(), player.getName());
        fakeProfile.getProperties().replaceValues((Object)"textures", (Iterable)PlayerProfileEditor.getPlayerProfile(player).getProperties().get((Object)"textures"));
        fakeProfiles.put(uuid, fakeProfile);
        return fakeProfile;
    }

    private static GameProfile getPlayerProfile(Player player) {
        try {
            return (GameProfile)playerGameProfile.get(((CraftPlayer)player).getHandle());
        }
        catch (Exception e) {
            dB.echoError(e);
            return null;
        }
    }

    public static void setProfileName(GameProfile gameProfile, String name) {
        try {
            gameProfileName.set(gameProfile, name);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static void setProfileId(GameProfile gameProfile, UUID uuid) {
        try {
            gameProfileId.set(gameProfile, uuid);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutPlayerInfo.class);
        playerInfo_action = fields.get("a");
        playerInfo_data = fields.get("b");
        Field profileField = null;
        Field profileIdField = null;
        Field profileNameField = null;
        Field pidGameProfile = null;
        try {
            profileField = EntityHuman.class.getDeclaredField("bS");
            profileField.setAccessible(true);
            profileIdField = GameProfile.class.getDeclaredField("id");
            profileIdField.setAccessible(true);
            profileNameField = GameProfile.class.getDeclaredField("name");
            profileNameField.setAccessible(true);
            for (Class<?> clzz : PacketPlayOutPlayerInfo.class.getDeclaredClasses()) {
                if (!clzz.getName().toLowerCase().contains("infodata")) continue;
                pidGameProfile = clzz.getDeclaredField("d");
            }
            pidGameProfile.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        playerGameProfile = profileField;
        gameProfileId = profileIdField;
        gameProfileName = profileNameField;
        playerInfoData_gameProfile = pidGameProfile;
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new PlayerProfileEditorListener(), (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static class PlayerProfileEditorListener
    implements Listener {
        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (fakeProfiles.containsKey(uuid)) {
                fakeProfiles.remove(uuid);
            }
        }
    }
}

